/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.actuator.storage;

import com.azure.core.http.rest.Response;
import com.azure.spring.cloud.actuator.implementation.util.ActuateConstants;
import com.azure.storage.queue.QueueServiceAsyncClient;
import java.time.Duration;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public class StorageQueueHealthIndicator
extends AbstractHealthIndicator {
    private final QueueServiceAsyncClient internalClient;
    private Duration timeout = ActuateConstants.DEFAULT_HEALTH_CHECK_TIMEOUT;

    public StorageQueueHealthIndicator(QueueServiceAsyncClient queueServiceClient) {
        this.internalClient = queueServiceClient;
    }

    protected void doHealthCheck(Health.Builder builder) {
        builder.withDetail("URL", (Object)this.internalClient.getQueueServiceUrl());
        Response infoResponse = (Response)this.internalClient.getPropertiesWithResponse().block(this.timeout);
        if (infoResponse != null) {
            builder.up();
        }
    }

    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }
}

