/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.actuator.appconfiguration;

import com.azure.spring.cloud.appconfiguration.config.AppConfigurationRefresh;
import com.azure.spring.cloud.appconfiguration.config.AppConfigurationStoreHealth;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;

public final class AppConfigurationConfigHealthIndicator
implements HealthIndicator {
    private final AppConfigurationRefresh refresh;

    public AppConfigurationConfigHealthIndicator(AppConfigurationRefresh refresh) {
        this.refresh = refresh;
    }

    public Health health() {
        Health.Builder healthBuilder = new Health.Builder();
        boolean healthy = true;
        for (String store : this.refresh.getAppConfigurationStoresHealth().keySet()) {
            if (AppConfigurationStoreHealth.DOWN.equals(this.refresh.getAppConfigurationStoresHealth().get(store))) {
                healthy = false;
                healthBuilder.withDetail(store, (Object)AppConfigurationStoreHealth.DOWN.toString());
                continue;
            }
            if (AppConfigurationStoreHealth.NOT_LOADED.equals(this.refresh.getAppConfigurationStoresHealth().get(store))) {
                healthBuilder.withDetail(store, (Object)AppConfigurationStoreHealth.NOT_LOADED.toString());
                continue;
            }
            healthBuilder.withDetail(store, (Object)AppConfigurationStoreHealth.UP.toString());
        }
        if (!healthy) {
            return healthBuilder.down().build();
        }
        return healthBuilder.up().build();
    }
}

