/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SAPVirtualInstanceIdentity;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.UpdateSapVirtualInstanceProperties;
import java.io.IOException;
import java.util.Map;

public final class UpdateSapVirtualInstanceRequest
implements JsonSerializable<UpdateSapVirtualInstanceRequest> {
    private Map<String, String> tags;
    private SAPVirtualInstanceIdentity identity;
    private UpdateSapVirtualInstanceProperties properties;

    public Map<String, String> tags() {
        return this.tags;
    }

    public UpdateSapVirtualInstanceRequest withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public SAPVirtualInstanceIdentity identity() {
        return this.identity;
    }

    public UpdateSapVirtualInstanceRequest withIdentity(SAPVirtualInstanceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public UpdateSapVirtualInstanceProperties properties() {
        return this.properties;
    }

    public UpdateSapVirtualInstanceRequest withProperties(UpdateSapVirtualInstanceProperties properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static UpdateSapVirtualInstanceRequest fromJson(JsonReader jsonReader) throws IOException {
        return (UpdateSapVirtualInstanceRequest)jsonReader.readObject(reader -> {
            UpdateSapVirtualInstanceRequest deserializedUpdateSapVirtualInstanceRequest = new UpdateSapVirtualInstanceRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedUpdateSapVirtualInstanceRequest.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedUpdateSapVirtualInstanceRequest.identity = SAPVirtualInstanceIdentity.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedUpdateSapVirtualInstanceRequest.properties = UpdateSapVirtualInstanceProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUpdateSapVirtualInstanceRequest;
        });
    }
}

