/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.fluent.models.SapSizingRecommendationResultInner;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapDeploymentType;
import java.io.IOException;

public final class ThreeTierRecommendationResult
extends SapSizingRecommendationResultInner {
    private SapDeploymentType deploymentType = SapDeploymentType.THREE_TIER;
    private String dbVmSku;
    private Long databaseInstanceCount;
    private String centralServerVmSku;
    private Long centralServerInstanceCount;
    private String applicationServerVmSku;
    private Long applicationServerInstanceCount;

    private ThreeTierRecommendationResult() {
    }

    @Override
    public SapDeploymentType deploymentType() {
        return this.deploymentType;
    }

    public String dbVmSku() {
        return this.dbVmSku;
    }

    public Long databaseInstanceCount() {
        return this.databaseInstanceCount;
    }

    public String centralServerVmSku() {
        return this.centralServerVmSku;
    }

    public Long centralServerInstanceCount() {
        return this.centralServerInstanceCount;
    }

    public String applicationServerVmSku() {
        return this.applicationServerVmSku;
    }

    public Long applicationServerInstanceCount() {
        return this.applicationServerInstanceCount;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("deploymentType", this.deploymentType == null ? null : this.deploymentType.toString());
        jsonWriter.writeStringField("dbVmSku", this.dbVmSku);
        jsonWriter.writeNumberField("databaseInstanceCount", (Number)this.databaseInstanceCount);
        jsonWriter.writeStringField("centralServerVmSku", this.centralServerVmSku);
        jsonWriter.writeNumberField("centralServerInstanceCount", (Number)this.centralServerInstanceCount);
        jsonWriter.writeStringField("applicationServerVmSku", this.applicationServerVmSku);
        jsonWriter.writeNumberField("applicationServerInstanceCount", (Number)this.applicationServerInstanceCount);
        return jsonWriter.writeEndObject();
    }

    public static ThreeTierRecommendationResult fromJson(JsonReader jsonReader) throws IOException {
        return (ThreeTierRecommendationResult)jsonReader.readObject(reader -> {
            ThreeTierRecommendationResult deserializedThreeTierRecommendationResult = new ThreeTierRecommendationResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("deploymentType".equals(fieldName)) {
                    deserializedThreeTierRecommendationResult.deploymentType = SapDeploymentType.fromString(reader.getString());
                    continue;
                }
                if ("dbVmSku".equals(fieldName)) {
                    deserializedThreeTierRecommendationResult.dbVmSku = reader.getString();
                    continue;
                }
                if ("databaseInstanceCount".equals(fieldName)) {
                    deserializedThreeTierRecommendationResult.databaseInstanceCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("centralServerVmSku".equals(fieldName)) {
                    deserializedThreeTierRecommendationResult.centralServerVmSku = reader.getString();
                    continue;
                }
                if ("centralServerInstanceCount".equals(fieldName)) {
                    deserializedThreeTierRecommendationResult.centralServerInstanceCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("applicationServerVmSku".equals(fieldName)) {
                    deserializedThreeTierRecommendationResult.applicationServerVmSku = reader.getString();
                    continue;
                }
                if ("applicationServerInstanceCount".equals(fieldName)) {
                    deserializedThreeTierRecommendationResult.applicationServerInstanceCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedThreeTierRecommendationResult;
        });
    }
}

