/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.DiskConfiguration;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.InfrastructureConfiguration;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.NetworkConfiguration;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapDatabaseType;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapDeploymentType;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SingleServerCustomResourceNames;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.VirtualMachineConfiguration;
import java.io.IOException;

public final class SingleServerConfiguration
extends InfrastructureConfiguration {
    private SapDeploymentType deploymentType = SapDeploymentType.SINGLE_SERVER;
    private NetworkConfiguration networkConfiguration;
    private SapDatabaseType databaseType;
    private String subnetId;
    private VirtualMachineConfiguration virtualMachineConfiguration;
    private DiskConfiguration dbDiskConfiguration;
    private SingleServerCustomResourceNames customResourceNames;
    private static final ClientLogger LOGGER = new ClientLogger(SingleServerConfiguration.class);

    @Override
    public SapDeploymentType deploymentType() {
        return this.deploymentType;
    }

    public NetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public SingleServerConfiguration withNetworkConfiguration(NetworkConfiguration networkConfiguration) {
        this.networkConfiguration = networkConfiguration;
        return this;
    }

    public SapDatabaseType databaseType() {
        return this.databaseType;
    }

    public SingleServerConfiguration withDatabaseType(SapDatabaseType databaseType) {
        this.databaseType = databaseType;
        return this;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public SingleServerConfiguration withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    public VirtualMachineConfiguration virtualMachineConfiguration() {
        return this.virtualMachineConfiguration;
    }

    public SingleServerConfiguration withVirtualMachineConfiguration(VirtualMachineConfiguration virtualMachineConfiguration) {
        this.virtualMachineConfiguration = virtualMachineConfiguration;
        return this;
    }

    public DiskConfiguration dbDiskConfiguration() {
        return this.dbDiskConfiguration;
    }

    public SingleServerConfiguration withDbDiskConfiguration(DiskConfiguration dbDiskConfiguration) {
        this.dbDiskConfiguration = dbDiskConfiguration;
        return this;
    }

    public SingleServerCustomResourceNames customResourceNames() {
        return this.customResourceNames;
    }

    public SingleServerConfiguration withCustomResourceNames(SingleServerCustomResourceNames customResourceNames) {
        this.customResourceNames = customResourceNames;
        return this;
    }

    @Override
    public SingleServerConfiguration withAppResourceGroup(String appResourceGroup) {
        super.withAppResourceGroup(appResourceGroup);
        return this;
    }

    @Override
    public void validate() {
        if (this.networkConfiguration() != null) {
            this.networkConfiguration().validate();
        }
        if (this.subnetId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property subnetId in model SingleServerConfiguration"));
        }
        if (this.virtualMachineConfiguration() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property virtualMachineConfiguration in model SingleServerConfiguration"));
        }
        this.virtualMachineConfiguration().validate();
        if (this.dbDiskConfiguration() != null) {
            this.dbDiskConfiguration().validate();
        }
        if (this.customResourceNames() != null) {
            this.customResourceNames().validate();
        }
        if (this.appResourceGroup() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property appResourceGroup in model SingleServerConfiguration"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("appResourceGroup", this.appResourceGroup());
        jsonWriter.writeStringField("subnetId", this.subnetId);
        jsonWriter.writeJsonField("virtualMachineConfiguration", (JsonSerializable)this.virtualMachineConfiguration);
        jsonWriter.writeStringField("deploymentType", this.deploymentType == null ? null : this.deploymentType.toString());
        jsonWriter.writeJsonField("networkConfiguration", (JsonSerializable)this.networkConfiguration);
        jsonWriter.writeStringField("databaseType", this.databaseType == null ? null : this.databaseType.toString());
        jsonWriter.writeJsonField("dbDiskConfiguration", (JsonSerializable)this.dbDiskConfiguration);
        jsonWriter.writeJsonField("customResourceNames", (JsonSerializable)this.customResourceNames);
        return jsonWriter.writeEndObject();
    }

    public static SingleServerConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (SingleServerConfiguration)jsonReader.readObject(reader -> {
            SingleServerConfiguration deserializedSingleServerConfiguration = new SingleServerConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("appResourceGroup".equals(fieldName)) {
                    deserializedSingleServerConfiguration.withAppResourceGroup(reader.getString());
                    continue;
                }
                if ("subnetId".equals(fieldName)) {
                    deserializedSingleServerConfiguration.subnetId = reader.getString();
                    continue;
                }
                if ("virtualMachineConfiguration".equals(fieldName)) {
                    deserializedSingleServerConfiguration.virtualMachineConfiguration = VirtualMachineConfiguration.fromJson(reader);
                    continue;
                }
                if ("deploymentType".equals(fieldName)) {
                    deserializedSingleServerConfiguration.deploymentType = SapDeploymentType.fromString(reader.getString());
                    continue;
                }
                if ("networkConfiguration".equals(fieldName)) {
                    deserializedSingleServerConfiguration.networkConfiguration = NetworkConfiguration.fromJson(reader);
                    continue;
                }
                if ("databaseType".equals(fieldName)) {
                    deserializedSingleServerConfiguration.databaseType = SapDatabaseType.fromString(reader.getString());
                    continue;
                }
                if ("dbDiskConfiguration".equals(fieldName)) {
                    deserializedSingleServerConfiguration.dbDiskConfiguration = DiskConfiguration.fromJson(reader);
                    continue;
                }
                if ("customResourceNames".equals(fieldName)) {
                    deserializedSingleServerConfiguration.customResourceNames = SingleServerCustomResourceNames.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSingleServerConfiguration;
        });
    }
}

