/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.HighAvailabilitySoftwareConfiguration;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapSoftwareInstallationType;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SoftwareConfiguration;
import java.io.IOException;

public final class ServiceInitiatedSoftwareConfiguration
extends SoftwareConfiguration {
    private SapSoftwareInstallationType softwareInstallationType = SapSoftwareInstallationType.SERVICE_INITIATED;
    private String bomUrl;
    private String softwareVersion;
    private String sapBitsStorageAccountId;
    private String sapFqdn;
    private String sshPrivateKey;
    private HighAvailabilitySoftwareConfiguration highAvailabilitySoftwareConfiguration;
    private static final ClientLogger LOGGER = new ClientLogger(ServiceInitiatedSoftwareConfiguration.class);

    @Override
    public SapSoftwareInstallationType softwareInstallationType() {
        return this.softwareInstallationType;
    }

    public String bomUrl() {
        return this.bomUrl;
    }

    public ServiceInitiatedSoftwareConfiguration withBomUrl(String bomUrl) {
        this.bomUrl = bomUrl;
        return this;
    }

    public String softwareVersion() {
        return this.softwareVersion;
    }

    public ServiceInitiatedSoftwareConfiguration withSoftwareVersion(String softwareVersion) {
        this.softwareVersion = softwareVersion;
        return this;
    }

    public String sapBitsStorageAccountId() {
        return this.sapBitsStorageAccountId;
    }

    public ServiceInitiatedSoftwareConfiguration withSapBitsStorageAccountId(String sapBitsStorageAccountId) {
        this.sapBitsStorageAccountId = sapBitsStorageAccountId;
        return this;
    }

    public String sapFqdn() {
        return this.sapFqdn;
    }

    public ServiceInitiatedSoftwareConfiguration withSapFqdn(String sapFqdn) {
        this.sapFqdn = sapFqdn;
        return this;
    }

    public String sshPrivateKey() {
        return this.sshPrivateKey;
    }

    public ServiceInitiatedSoftwareConfiguration withSshPrivateKey(String sshPrivateKey) {
        this.sshPrivateKey = sshPrivateKey;
        return this;
    }

    public HighAvailabilitySoftwareConfiguration highAvailabilitySoftwareConfiguration() {
        return this.highAvailabilitySoftwareConfiguration;
    }

    public ServiceInitiatedSoftwareConfiguration withHighAvailabilitySoftwareConfiguration(HighAvailabilitySoftwareConfiguration highAvailabilitySoftwareConfiguration) {
        this.highAvailabilitySoftwareConfiguration = highAvailabilitySoftwareConfiguration;
        return this;
    }

    @Override
    public void validate() {
        if (this.bomUrl() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property bomUrl in model ServiceInitiatedSoftwareConfiguration"));
        }
        if (this.softwareVersion() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property softwareVersion in model ServiceInitiatedSoftwareConfiguration"));
        }
        if (this.sapBitsStorageAccountId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sapBitsStorageAccountId in model ServiceInitiatedSoftwareConfiguration"));
        }
        if (this.sapFqdn() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sapFqdn in model ServiceInitiatedSoftwareConfiguration"));
        }
        if (this.sshPrivateKey() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sshPrivateKey in model ServiceInitiatedSoftwareConfiguration"));
        }
        if (this.highAvailabilitySoftwareConfiguration() != null) {
            this.highAvailabilitySoftwareConfiguration().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("bomUrl", this.bomUrl);
        jsonWriter.writeStringField("softwareVersion", this.softwareVersion);
        jsonWriter.writeStringField("sapBitsStorageAccountId", this.sapBitsStorageAccountId);
        jsonWriter.writeStringField("sapFqdn", this.sapFqdn);
        jsonWriter.writeStringField("sshPrivateKey", this.sshPrivateKey);
        jsonWriter.writeStringField("softwareInstallationType", this.softwareInstallationType == null ? null : this.softwareInstallationType.toString());
        jsonWriter.writeJsonField("highAvailabilitySoftwareConfiguration", (JsonSerializable)this.highAvailabilitySoftwareConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static ServiceInitiatedSoftwareConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (ServiceInitiatedSoftwareConfiguration)jsonReader.readObject(reader -> {
            ServiceInitiatedSoftwareConfiguration deserializedServiceInitiatedSoftwareConfiguration = new ServiceInitiatedSoftwareConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("bomUrl".equals(fieldName)) {
                    deserializedServiceInitiatedSoftwareConfiguration.bomUrl = reader.getString();
                    continue;
                }
                if ("softwareVersion".equals(fieldName)) {
                    deserializedServiceInitiatedSoftwareConfiguration.softwareVersion = reader.getString();
                    continue;
                }
                if ("sapBitsStorageAccountId".equals(fieldName)) {
                    deserializedServiceInitiatedSoftwareConfiguration.sapBitsStorageAccountId = reader.getString();
                    continue;
                }
                if ("sapFqdn".equals(fieldName)) {
                    deserializedServiceInitiatedSoftwareConfiguration.sapFqdn = reader.getString();
                    continue;
                }
                if ("sshPrivateKey".equals(fieldName)) {
                    deserializedServiceInitiatedSoftwareConfiguration.sshPrivateKey = reader.getString();
                    continue;
                }
                if ("softwareInstallationType".equals(fieldName)) {
                    deserializedServiceInitiatedSoftwareConfiguration.softwareInstallationType = SapSoftwareInstallationType.fromString(reader.getString());
                    continue;
                }
                if ("highAvailabilitySoftwareConfiguration".equals(fieldName)) {
                    deserializedServiceInitiatedSoftwareConfiguration.highAvailabilitySoftwareConfiguration = HighAvailabilitySoftwareConfiguration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServiceInitiatedSoftwareConfiguration;
        });
    }
}

