/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.HighAvailabilitySoftwareConfiguration;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapSoftwareInstallationType;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SoftwareConfiguration;
import java.io.IOException;

public final class SapInstallWithoutOSConfigSoftwareConfiguration
extends SoftwareConfiguration {
    private SapSoftwareInstallationType softwareInstallationType = SapSoftwareInstallationType.SAPINSTALL_WITHOUT_OSCONFIG;
    private String bomUrl;
    private String sapBitsStorageAccountId;
    private String softwareVersion;
    private HighAvailabilitySoftwareConfiguration highAvailabilitySoftwareConfiguration;
    private static final ClientLogger LOGGER = new ClientLogger(SapInstallWithoutOSConfigSoftwareConfiguration.class);

    @Override
    public SapSoftwareInstallationType softwareInstallationType() {
        return this.softwareInstallationType;
    }

    public String bomUrl() {
        return this.bomUrl;
    }

    public SapInstallWithoutOSConfigSoftwareConfiguration withBomUrl(String bomUrl) {
        this.bomUrl = bomUrl;
        return this;
    }

    public String sapBitsStorageAccountId() {
        return this.sapBitsStorageAccountId;
    }

    public SapInstallWithoutOSConfigSoftwareConfiguration withSapBitsStorageAccountId(String sapBitsStorageAccountId) {
        this.sapBitsStorageAccountId = sapBitsStorageAccountId;
        return this;
    }

    public String softwareVersion() {
        return this.softwareVersion;
    }

    public SapInstallWithoutOSConfigSoftwareConfiguration withSoftwareVersion(String softwareVersion) {
        this.softwareVersion = softwareVersion;
        return this;
    }

    public HighAvailabilitySoftwareConfiguration highAvailabilitySoftwareConfiguration() {
        return this.highAvailabilitySoftwareConfiguration;
    }

    public SapInstallWithoutOSConfigSoftwareConfiguration withHighAvailabilitySoftwareConfiguration(HighAvailabilitySoftwareConfiguration highAvailabilitySoftwareConfiguration) {
        this.highAvailabilitySoftwareConfiguration = highAvailabilitySoftwareConfiguration;
        return this;
    }

    @Override
    public void validate() {
        if (this.bomUrl() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property bomUrl in model SapInstallWithoutOSConfigSoftwareConfiguration"));
        }
        if (this.sapBitsStorageAccountId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sapBitsStorageAccountId in model SapInstallWithoutOSConfigSoftwareConfiguration"));
        }
        if (this.softwareVersion() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property softwareVersion in model SapInstallWithoutOSConfigSoftwareConfiguration"));
        }
        if (this.highAvailabilitySoftwareConfiguration() != null) {
            this.highAvailabilitySoftwareConfiguration().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("bomUrl", this.bomUrl);
        jsonWriter.writeStringField("sapBitsStorageAccountId", this.sapBitsStorageAccountId);
        jsonWriter.writeStringField("softwareVersion", this.softwareVersion);
        jsonWriter.writeStringField("softwareInstallationType", this.softwareInstallationType == null ? null : this.softwareInstallationType.toString());
        jsonWriter.writeJsonField("highAvailabilitySoftwareConfiguration", (JsonSerializable)this.highAvailabilitySoftwareConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static SapInstallWithoutOSConfigSoftwareConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (SapInstallWithoutOSConfigSoftwareConfiguration)jsonReader.readObject(reader -> {
            SapInstallWithoutOSConfigSoftwareConfiguration deserializedSapInstallWithoutOSConfigSoftwareConfiguration = new SapInstallWithoutOSConfigSoftwareConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("bomUrl".equals(fieldName)) {
                    deserializedSapInstallWithoutOSConfigSoftwareConfiguration.bomUrl = reader.getString();
                    continue;
                }
                if ("sapBitsStorageAccountId".equals(fieldName)) {
                    deserializedSapInstallWithoutOSConfigSoftwareConfiguration.sapBitsStorageAccountId = reader.getString();
                    continue;
                }
                if ("softwareVersion".equals(fieldName)) {
                    deserializedSapInstallWithoutOSConfigSoftwareConfiguration.softwareVersion = reader.getString();
                    continue;
                }
                if ("softwareInstallationType".equals(fieldName)) {
                    deserializedSapInstallWithoutOSConfigSoftwareConfiguration.softwareInstallationType = SapSoftwareInstallationType.fromString(reader.getString());
                    continue;
                }
                if ("highAvailabilitySoftwareConfiguration".equals(fieldName)) {
                    deserializedSapInstallWithoutOSConfigSoftwareConfiguration.highAvailabilitySoftwareConfiguration = HighAvailabilitySoftwareConfiguration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSapInstallWithoutOSConfigSoftwareConfiguration;
        });
    }
}

