/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapDatabaseType;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapDeploymentType;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapEnvironmentType;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapProductType;
import java.io.IOException;

public final class SapDiskConfigurationsRequest
implements JsonSerializable<SapDiskConfigurationsRequest> {
    private String appLocation;
    private SapEnvironmentType environment;
    private SapProductType sapProduct;
    private SapDatabaseType databaseType;
    private SapDeploymentType deploymentType;
    private String dbVmSku;
    private static final ClientLogger LOGGER = new ClientLogger(SapDiskConfigurationsRequest.class);

    public String appLocation() {
        return this.appLocation;
    }

    public SapDiskConfigurationsRequest withAppLocation(String appLocation) {
        this.appLocation = appLocation;
        return this;
    }

    public SapEnvironmentType environment() {
        return this.environment;
    }

    public SapDiskConfigurationsRequest withEnvironment(SapEnvironmentType environment) {
        this.environment = environment;
        return this;
    }

    public SapProductType sapProduct() {
        return this.sapProduct;
    }

    public SapDiskConfigurationsRequest withSapProduct(SapProductType sapProduct) {
        this.sapProduct = sapProduct;
        return this;
    }

    public SapDatabaseType databaseType() {
        return this.databaseType;
    }

    public SapDiskConfigurationsRequest withDatabaseType(SapDatabaseType databaseType) {
        this.databaseType = databaseType;
        return this;
    }

    public SapDeploymentType deploymentType() {
        return this.deploymentType;
    }

    public SapDiskConfigurationsRequest withDeploymentType(SapDeploymentType deploymentType) {
        this.deploymentType = deploymentType;
        return this;
    }

    public String dbVmSku() {
        return this.dbVmSku;
    }

    public SapDiskConfigurationsRequest withDbVmSku(String dbVmSku) {
        this.dbVmSku = dbVmSku;
        return this;
    }

    public void validate() {
        if (this.appLocation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property appLocation in model SapDiskConfigurationsRequest"));
        }
        if (this.environment() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property environment in model SapDiskConfigurationsRequest"));
        }
        if (this.sapProduct() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sapProduct in model SapDiskConfigurationsRequest"));
        }
        if (this.databaseType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property databaseType in model SapDiskConfigurationsRequest"));
        }
        if (this.deploymentType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property deploymentType in model SapDiskConfigurationsRequest"));
        }
        if (this.dbVmSku() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dbVmSku in model SapDiskConfigurationsRequest"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("appLocation", this.appLocation);
        jsonWriter.writeStringField("environment", this.environment == null ? null : this.environment.toString());
        jsonWriter.writeStringField("sapProduct", this.sapProduct == null ? null : this.sapProduct.toString());
        jsonWriter.writeStringField("databaseType", this.databaseType == null ? null : this.databaseType.toString());
        jsonWriter.writeStringField("deploymentType", this.deploymentType == null ? null : this.deploymentType.toString());
        jsonWriter.writeStringField("dbVmSku", this.dbVmSku);
        return jsonWriter.writeEndObject();
    }

    public static SapDiskConfigurationsRequest fromJson(JsonReader jsonReader) throws IOException {
        return (SapDiskConfigurationsRequest)jsonReader.readObject(reader -> {
            SapDiskConfigurationsRequest deserializedSapDiskConfigurationsRequest = new SapDiskConfigurationsRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("appLocation".equals(fieldName)) {
                    deserializedSapDiskConfigurationsRequest.appLocation = reader.getString();
                    continue;
                }
                if ("environment".equals(fieldName)) {
                    deserializedSapDiskConfigurationsRequest.environment = SapEnvironmentType.fromString(reader.getString());
                    continue;
                }
                if ("sapProduct".equals(fieldName)) {
                    deserializedSapDiskConfigurationsRequest.sapProduct = SapProductType.fromString(reader.getString());
                    continue;
                }
                if ("databaseType".equals(fieldName)) {
                    deserializedSapDiskConfigurationsRequest.databaseType = SapDatabaseType.fromString(reader.getString());
                    continue;
                }
                if ("deploymentType".equals(fieldName)) {
                    deserializedSapDiskConfigurationsRequest.deploymentType = SapDeploymentType.fromString(reader.getString());
                    continue;
                }
                if ("dbVmSku".equals(fieldName)) {
                    deserializedSapDiskConfigurationsRequest.dbVmSku = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSapDiskConfigurationsRequest;
        });
    }
}

