/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.ApplicationServerVmDetails;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.LoadBalancerDetails;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapHealthState;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapVirtualInstanceError;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapVirtualInstanceProvisioningState;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapVirtualInstanceStatus;
import java.io.IOException;
import java.util.List;

public final class SapApplicationServerProperties
implements JsonSerializable<SapApplicationServerProperties> {
    private String instanceNo;
    private String subnet;
    private String hostname;
    private String kernelVersion;
    private String kernelPatch;
    private String ipAddress;
    private Long gatewayPort;
    private Long icmHttpPort;
    private Long icmHttpsPort;
    private String dispatcherStatus;
    private LoadBalancerDetails loadBalancerDetails;
    private List<ApplicationServerVmDetails> vmDetails;
    private SapVirtualInstanceStatus status;
    private SapHealthState health;
    private SapVirtualInstanceProvisioningState provisioningState;
    private SapVirtualInstanceError errors;

    public String instanceNo() {
        return this.instanceNo;
    }

    public String subnet() {
        return this.subnet;
    }

    public String hostname() {
        return this.hostname;
    }

    public String kernelVersion() {
        return this.kernelVersion;
    }

    public String kernelPatch() {
        return this.kernelPatch;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public Long gatewayPort() {
        return this.gatewayPort;
    }

    public Long icmHttpPort() {
        return this.icmHttpPort;
    }

    public Long icmHttpsPort() {
        return this.icmHttpsPort;
    }

    public String dispatcherStatus() {
        return this.dispatcherStatus;
    }

    public LoadBalancerDetails loadBalancerDetails() {
        return this.loadBalancerDetails;
    }

    public List<ApplicationServerVmDetails> vmDetails() {
        return this.vmDetails;
    }

    public SapVirtualInstanceStatus status() {
        return this.status;
    }

    public SapHealthState health() {
        return this.health;
    }

    public SapVirtualInstanceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public SapVirtualInstanceError errors() {
        return this.errors;
    }

    public void validate() {
        if (this.loadBalancerDetails() != null) {
            this.loadBalancerDetails().validate();
        }
        if (this.vmDetails() != null) {
            this.vmDetails().forEach(e -> e.validate());
        }
        if (this.errors() != null) {
            this.errors().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static SapApplicationServerProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SapApplicationServerProperties)jsonReader.readObject(reader -> {
            SapApplicationServerProperties deserializedSapApplicationServerProperties = new SapApplicationServerProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("instanceNo".equals(fieldName)) {
                    deserializedSapApplicationServerProperties.instanceNo = reader.getString();
                    continue;
                }
                if ("subnet".equals(fieldName)) {
                    deserializedSapApplicationServerProperties.subnet = reader.getString();
                    continue;
                }
                if ("hostname".equals(fieldName)) {
                    deserializedSapApplicationServerProperties.hostname = reader.getString();
                    continue;
                }
                if ("kernelVersion".equals(fieldName)) {
                    deserializedSapApplicationServerProperties.kernelVersion = reader.getString();
                    continue;
                }
                if ("kernelPatch".equals(fieldName)) {
                    deserializedSapApplicationServerProperties.kernelPatch = reader.getString();
                    continue;
                }
                if ("ipAddress".equals(fieldName)) {
                    deserializedSapApplicationServerProperties.ipAddress = reader.getString();
                    continue;
                }
                if ("gatewayPort".equals(fieldName)) {
                    deserializedSapApplicationServerProperties.gatewayPort = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("icmHttpPort".equals(fieldName)) {
                    deserializedSapApplicationServerProperties.icmHttpPort = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("icmHttpsPort".equals(fieldName)) {
                    deserializedSapApplicationServerProperties.icmHttpsPort = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("dispatcherStatus".equals(fieldName)) {
                    deserializedSapApplicationServerProperties.dispatcherStatus = reader.getString();
                    continue;
                }
                if ("loadBalancerDetails".equals(fieldName)) {
                    deserializedSapApplicationServerProperties.loadBalancerDetails = LoadBalancerDetails.fromJson(reader);
                    continue;
                }
                if ("vmDetails".equals(fieldName)) {
                    List vmDetails;
                    deserializedSapApplicationServerProperties.vmDetails = vmDetails = reader.readArray(reader1 -> ApplicationServerVmDetails.fromJson(reader1));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedSapApplicationServerProperties.status = SapVirtualInstanceStatus.fromString(reader.getString());
                    continue;
                }
                if ("health".equals(fieldName)) {
                    deserializedSapApplicationServerProperties.health = SapHealthState.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedSapApplicationServerProperties.provisioningState = SapVirtualInstanceProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("errors".equals(fieldName)) {
                    deserializedSapApplicationServerProperties.errors = SapVirtualInstanceError.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSapApplicationServerProperties;
        });
    }
}

