/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.FileShareConfiguration;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.FileShareConfigurationType;
import java.io.IOException;

public final class MountFileShareConfiguration
extends FileShareConfiguration {
    private FileShareConfigurationType configurationType = FileShareConfigurationType.MOUNT;
    private String id;
    private String privateEndpointId;
    private static final ClientLogger LOGGER = new ClientLogger(MountFileShareConfiguration.class);

    @Override
    public FileShareConfigurationType configurationType() {
        return this.configurationType;
    }

    public String id() {
        return this.id;
    }

    public MountFileShareConfiguration withId(String id) {
        this.id = id;
        return this;
    }

    public String privateEndpointId() {
        return this.privateEndpointId;
    }

    public MountFileShareConfiguration withPrivateEndpointId(String privateEndpointId) {
        this.privateEndpointId = privateEndpointId;
        return this;
    }

    @Override
    public void validate() {
        if (this.id() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property id in model MountFileShareConfiguration"));
        }
        if (this.privateEndpointId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property privateEndpointId in model MountFileShareConfiguration"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("privateEndpointId", this.privateEndpointId);
        jsonWriter.writeStringField("configurationType", this.configurationType == null ? null : this.configurationType.toString());
        return jsonWriter.writeEndObject();
    }

    public static MountFileShareConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (MountFileShareConfiguration)jsonReader.readObject(reader -> {
            MountFileShareConfiguration deserializedMountFileShareConfiguration = new MountFileShareConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMountFileShareConfiguration.id = reader.getString();
                    continue;
                }
                if ("privateEndpointId".equals(fieldName)) {
                    deserializedMountFileShareConfiguration.privateEndpointId = reader.getString();
                    continue;
                }
                if ("configurationType".equals(fieldName)) {
                    deserializedMountFileShareConfiguration.configurationType = FileShareConfigurationType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMountFileShareConfiguration;
        });
    }
}

