/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapSoftwareInstallationType;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SoftwareConfiguration;
import java.io.IOException;

public final class ExternalInstallationSoftwareConfiguration
extends SoftwareConfiguration {
    private SapSoftwareInstallationType softwareInstallationType = SapSoftwareInstallationType.EXTERNAL;
    private String centralServerVmId;

    @Override
    public SapSoftwareInstallationType softwareInstallationType() {
        return this.softwareInstallationType;
    }

    public String centralServerVmId() {
        return this.centralServerVmId;
    }

    public ExternalInstallationSoftwareConfiguration withCentralServerVmId(String centralServerVmId) {
        this.centralServerVmId = centralServerVmId;
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("softwareInstallationType", this.softwareInstallationType == null ? null : this.softwareInstallationType.toString());
        jsonWriter.writeStringField("centralServerVmId", this.centralServerVmId);
        return jsonWriter.writeEndObject();
    }

    public static ExternalInstallationSoftwareConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (ExternalInstallationSoftwareConfiguration)jsonReader.readObject(reader -> {
            ExternalInstallationSoftwareConfiguration deserializedExternalInstallationSoftwareConfiguration = new ExternalInstallationSoftwareConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("softwareInstallationType".equals(fieldName)) {
                    deserializedExternalInstallationSoftwareConfiguration.softwareInstallationType = SapSoftwareInstallationType.fromString(reader.getString());
                    continue;
                }
                if ("centralServerVmId".equals(fieldName)) {
                    deserializedExternalInstallationSoftwareConfiguration.centralServerVmId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExternalInstallationSoftwareConfiguration;
        });
    }
}

