/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.DiskConfiguration;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapDatabaseType;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.VirtualMachineConfiguration;
import java.io.IOException;

public final class DatabaseConfiguration
implements JsonSerializable<DatabaseConfiguration> {
    private SapDatabaseType databaseType;
    private String subnetId;
    private VirtualMachineConfiguration virtualMachineConfiguration;
    private long instanceCount;
    private DiskConfiguration diskConfiguration;
    private static final ClientLogger LOGGER = new ClientLogger(DatabaseConfiguration.class);

    public SapDatabaseType databaseType() {
        return this.databaseType;
    }

    public DatabaseConfiguration withDatabaseType(SapDatabaseType databaseType) {
        this.databaseType = databaseType;
        return this;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public DatabaseConfiguration withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    public VirtualMachineConfiguration virtualMachineConfiguration() {
        return this.virtualMachineConfiguration;
    }

    public DatabaseConfiguration withVirtualMachineConfiguration(VirtualMachineConfiguration virtualMachineConfiguration) {
        this.virtualMachineConfiguration = virtualMachineConfiguration;
        return this;
    }

    public long instanceCount() {
        return this.instanceCount;
    }

    public DatabaseConfiguration withInstanceCount(long instanceCount) {
        this.instanceCount = instanceCount;
        return this;
    }

    public DiskConfiguration diskConfiguration() {
        return this.diskConfiguration;
    }

    public DatabaseConfiguration withDiskConfiguration(DiskConfiguration diskConfiguration) {
        this.diskConfiguration = diskConfiguration;
        return this;
    }

    public void validate() {
        if (this.subnetId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property subnetId in model DatabaseConfiguration"));
        }
        if (this.virtualMachineConfiguration() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property virtualMachineConfiguration in model DatabaseConfiguration"));
        }
        this.virtualMachineConfiguration().validate();
        if (this.diskConfiguration() != null) {
            this.diskConfiguration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("subnetId", this.subnetId);
        jsonWriter.writeJsonField("virtualMachineConfiguration", (JsonSerializable)this.virtualMachineConfiguration);
        jsonWriter.writeLongField("instanceCount", this.instanceCount);
        jsonWriter.writeStringField("databaseType", this.databaseType == null ? null : this.databaseType.toString());
        jsonWriter.writeJsonField("diskConfiguration", (JsonSerializable)this.diskConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static DatabaseConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseConfiguration)jsonReader.readObject(reader -> {
            DatabaseConfiguration deserializedDatabaseConfiguration = new DatabaseConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("subnetId".equals(fieldName)) {
                    deserializedDatabaseConfiguration.subnetId = reader.getString();
                    continue;
                }
                if ("virtualMachineConfiguration".equals(fieldName)) {
                    deserializedDatabaseConfiguration.virtualMachineConfiguration = VirtualMachineConfiguration.fromJson(reader);
                    continue;
                }
                if ("instanceCount".equals(fieldName)) {
                    deserializedDatabaseConfiguration.instanceCount = reader.getLong();
                    continue;
                }
                if ("databaseType".equals(fieldName)) {
                    deserializedDatabaseConfiguration.databaseType = SapDatabaseType.fromString(reader.getString());
                    continue;
                }
                if ("diskConfiguration".equals(fieldName)) {
                    deserializedDatabaseConfiguration.diskConfiguration = DiskConfiguration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseConfiguration;
        });
    }
}

