/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.FileShareConfiguration;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.FileShareConfigurationType;
import java.io.IOException;

public final class CreateAndMountFileShareConfiguration
extends FileShareConfiguration {
    private FileShareConfigurationType configurationType = FileShareConfigurationType.CREATE_AND_MOUNT;
    private String resourceGroup;
    private String storageAccountName;

    @Override
    public FileShareConfigurationType configurationType() {
        return this.configurationType;
    }

    public String resourceGroup() {
        return this.resourceGroup;
    }

    public CreateAndMountFileShareConfiguration withResourceGroup(String resourceGroup) {
        this.resourceGroup = resourceGroup;
        return this;
    }

    public String storageAccountName() {
        return this.storageAccountName;
    }

    public CreateAndMountFileShareConfiguration withStorageAccountName(String storageAccountName) {
        this.storageAccountName = storageAccountName;
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("configurationType", this.configurationType == null ? null : this.configurationType.toString());
        jsonWriter.writeStringField("resourceGroup", this.resourceGroup);
        jsonWriter.writeStringField("storageAccountName", this.storageAccountName);
        return jsonWriter.writeEndObject();
    }

    public static CreateAndMountFileShareConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (CreateAndMountFileShareConfiguration)jsonReader.readObject(reader -> {
            CreateAndMountFileShareConfiguration deserializedCreateAndMountFileShareConfiguration = new CreateAndMountFileShareConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("configurationType".equals(fieldName)) {
                    deserializedCreateAndMountFileShareConfiguration.configurationType = FileShareConfigurationType.fromString(reader.getString());
                    continue;
                }
                if ("resourceGroup".equals(fieldName)) {
                    deserializedCreateAndMountFileShareConfiguration.resourceGroup = reader.getString();
                    continue;
                }
                if ("storageAccountName".equals(fieldName)) {
                    deserializedCreateAndMountFileShareConfiguration.storageAccountName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCreateAndMountFileShareConfiguration;
        });
    }
}

