/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.VirtualMachineResourceNames;
import java.io.IOException;
import java.util.List;

public final class ApplicationServerFullResourceNames
implements JsonSerializable<ApplicationServerFullResourceNames> {
    private List<VirtualMachineResourceNames> virtualMachines;
    private String availabilitySetName;

    public List<VirtualMachineResourceNames> virtualMachines() {
        return this.virtualMachines;
    }

    public ApplicationServerFullResourceNames withVirtualMachines(List<VirtualMachineResourceNames> virtualMachines) {
        this.virtualMachines = virtualMachines;
        return this;
    }

    public String availabilitySetName() {
        return this.availabilitySetName;
    }

    public ApplicationServerFullResourceNames withAvailabilitySetName(String availabilitySetName) {
        this.availabilitySetName = availabilitySetName;
        return this;
    }

    public void validate() {
        if (this.virtualMachines() != null) {
            this.virtualMachines().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("virtualMachines", this.virtualMachines, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("availabilitySetName", this.availabilitySetName);
        return jsonWriter.writeEndObject();
    }

    public static ApplicationServerFullResourceNames fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationServerFullResourceNames)jsonReader.readObject(reader -> {
            ApplicationServerFullResourceNames deserializedApplicationServerFullResourceNames = new ApplicationServerFullResourceNames();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("virtualMachines".equals(fieldName)) {
                    List virtualMachines;
                    deserializedApplicationServerFullResourceNames.virtualMachines = virtualMachines = reader.readArray(reader1 -> VirtualMachineResourceNames.fromJson(reader1));
                    continue;
                }
                if ("availabilitySetName".equals(fieldName)) {
                    deserializedApplicationServerFullResourceNames.availabilitySetName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationServerFullResourceNames;
        });
    }
}

