/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.workloadssapvirtualinstance.WorkloadsSapVirtualInstanceManager;
import com.azure.resourcemanager.workloadssapvirtualinstance.fluent.models.SapVirtualInstanceInner;
import com.azure.resourcemanager.workloadssapvirtualinstance.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.OperationStatusResult;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SAPVirtualInstanceIdentity;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapVirtualInstance;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapVirtualInstanceProperties;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.StartRequest;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.StopRequest;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.UpdateSapVirtualInstanceProperties;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.UpdateSapVirtualInstanceRequest;
import java.util.Collections;
import java.util.Map;

public final class SapVirtualInstanceImpl
implements SapVirtualInstance,
SapVirtualInstance.Definition,
SapVirtualInstance.Update {
    private SapVirtualInstanceInner innerObject;
    private final WorkloadsSapVirtualInstanceManager serviceManager;
    private String resourceGroupName;
    private String sapVirtualInstanceName;
    private UpdateSapVirtualInstanceRequest updateProperties;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public SapVirtualInstanceProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SAPVirtualInstanceIdentity identity() {
        return this.innerModel().identity();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public SapVirtualInstanceInner innerModel() {
        return this.innerObject;
    }

    private WorkloadsSapVirtualInstanceManager manager() {
        return this.serviceManager;
    }

    @Override
    public SapVirtualInstanceImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public SapVirtualInstance create() {
        this.innerObject = this.serviceManager.serviceClient().getSapVirtualInstances().create(this.resourceGroupName, this.sapVirtualInstanceName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public SapVirtualInstance create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getSapVirtualInstances().create(this.resourceGroupName, this.sapVirtualInstanceName, this.innerModel(), context);
        return this;
    }

    SapVirtualInstanceImpl(String name, WorkloadsSapVirtualInstanceManager serviceManager) {
        this.innerObject = new SapVirtualInstanceInner();
        this.serviceManager = serviceManager;
        this.sapVirtualInstanceName = name;
    }

    @Override
    public SapVirtualInstanceImpl update() {
        this.updateProperties = new UpdateSapVirtualInstanceRequest();
        return this;
    }

    @Override
    public SapVirtualInstance apply() {
        this.innerObject = this.serviceManager.serviceClient().getSapVirtualInstances().update(this.resourceGroupName, this.sapVirtualInstanceName, this.updateProperties, Context.NONE);
        return this;
    }

    @Override
    public SapVirtualInstance apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getSapVirtualInstances().update(this.resourceGroupName, this.sapVirtualInstanceName, this.updateProperties, context);
        return this;
    }

    SapVirtualInstanceImpl(SapVirtualInstanceInner innerObject, WorkloadsSapVirtualInstanceManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.sapVirtualInstanceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "sapVirtualInstances");
    }

    @Override
    public SapVirtualInstance refresh() {
        this.innerObject = (SapVirtualInstanceInner)((Object)this.serviceManager.serviceClient().getSapVirtualInstances().getByResourceGroupWithResponse(this.resourceGroupName, this.sapVirtualInstanceName, Context.NONE).getValue());
        return this;
    }

    @Override
    public SapVirtualInstance refresh(Context context) {
        this.innerObject = (SapVirtualInstanceInner)((Object)this.serviceManager.serviceClient().getSapVirtualInstances().getByResourceGroupWithResponse(this.resourceGroupName, this.sapVirtualInstanceName, context).getValue());
        return this;
    }

    @Override
    public OperationStatusResult start() {
        return this.serviceManager.sapVirtualInstances().start(this.resourceGroupName, this.sapVirtualInstanceName);
    }

    @Override
    public OperationStatusResult start(StartRequest body, Context context) {
        return this.serviceManager.sapVirtualInstances().start(this.resourceGroupName, this.sapVirtualInstanceName, body, context);
    }

    @Override
    public OperationStatusResult stop() {
        return this.serviceManager.sapVirtualInstances().stop(this.resourceGroupName, this.sapVirtualInstanceName);
    }

    @Override
    public OperationStatusResult stop(StopRequest body, Context context) {
        return this.serviceManager.sapVirtualInstances().stop(this.resourceGroupName, this.sapVirtualInstanceName, body, context);
    }

    @Override
    public SapVirtualInstanceImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public SapVirtualInstanceImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public SapVirtualInstanceImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateProperties.withTags(tags);
        return this;
    }

    @Override
    public SapVirtualInstanceImpl withProperties(SapVirtualInstanceProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public SapVirtualInstanceImpl withIdentity(SAPVirtualInstanceIdentity identity) {
        if (this.isInCreateMode()) {
            this.innerModel().withIdentity(identity);
            return this;
        }
        this.updateProperties.withIdentity(identity);
        return this;
    }

    @Override
    public SapVirtualInstanceImpl withProperties(UpdateSapVirtualInstanceProperties properties) {
        this.updateProperties.withProperties(properties);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

