/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.workloadssapvirtualinstance.WorkloadsSapVirtualInstanceManager;
import com.azure.resourcemanager.workloadssapvirtualinstance.fluent.models.SapCentralServerInstanceInner;
import com.azure.resourcemanager.workloadssapvirtualinstance.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.OperationStatusResult;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapCentralServerInstance;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapCentralServerProperties;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.StartRequest;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.StopRequest;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.UpdateSapCentralInstanceRequest;
import java.util.Collections;
import java.util.Map;

public final class SapCentralServerInstanceImpl
implements SapCentralServerInstance,
SapCentralServerInstance.Definition,
SapCentralServerInstance.Update {
    private SapCentralServerInstanceInner innerObject;
    private final WorkloadsSapVirtualInstanceManager serviceManager;
    private String resourceGroupName;
    private String sapVirtualInstanceName;
    private String centralInstanceName;
    private UpdateSapCentralInstanceRequest updateProperties;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public SapCentralServerProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public SapCentralServerInstanceInner innerModel() {
        return this.innerObject;
    }

    private WorkloadsSapVirtualInstanceManager manager() {
        return this.serviceManager;
    }

    @Override
    public SapCentralServerInstanceImpl withExistingSapVirtualInstance(String resourceGroupName, String sapVirtualInstanceName) {
        this.resourceGroupName = resourceGroupName;
        this.sapVirtualInstanceName = sapVirtualInstanceName;
        return this;
    }

    @Override
    public SapCentralServerInstance create() {
        this.innerObject = this.serviceManager.serviceClient().getSapCentralServerInstances().create(this.resourceGroupName, this.sapVirtualInstanceName, this.centralInstanceName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public SapCentralServerInstance create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getSapCentralServerInstances().create(this.resourceGroupName, this.sapVirtualInstanceName, this.centralInstanceName, this.innerModel(), context);
        return this;
    }

    SapCentralServerInstanceImpl(String name, WorkloadsSapVirtualInstanceManager serviceManager) {
        this.innerObject = new SapCentralServerInstanceInner();
        this.serviceManager = serviceManager;
        this.centralInstanceName = name;
    }

    @Override
    public SapCentralServerInstanceImpl update() {
        this.updateProperties = new UpdateSapCentralInstanceRequest();
        return this;
    }

    @Override
    public SapCentralServerInstance apply() {
        this.innerObject = (SapCentralServerInstanceInner)((Object)this.serviceManager.serviceClient().getSapCentralServerInstances().updateWithResponse(this.resourceGroupName, this.sapVirtualInstanceName, this.centralInstanceName, this.updateProperties, Context.NONE).getValue());
        return this;
    }

    @Override
    public SapCentralServerInstance apply(Context context) {
        this.innerObject = (SapCentralServerInstanceInner)((Object)this.serviceManager.serviceClient().getSapCentralServerInstances().updateWithResponse(this.resourceGroupName, this.sapVirtualInstanceName, this.centralInstanceName, this.updateProperties, context).getValue());
        return this;
    }

    SapCentralServerInstanceImpl(SapCentralServerInstanceInner innerObject, WorkloadsSapVirtualInstanceManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.sapVirtualInstanceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "sapVirtualInstances");
        this.centralInstanceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "centralInstances");
    }

    @Override
    public SapCentralServerInstance refresh() {
        this.innerObject = (SapCentralServerInstanceInner)((Object)this.serviceManager.serviceClient().getSapCentralServerInstances().getWithResponse(this.resourceGroupName, this.sapVirtualInstanceName, this.centralInstanceName, Context.NONE).getValue());
        return this;
    }

    @Override
    public SapCentralServerInstance refresh(Context context) {
        this.innerObject = (SapCentralServerInstanceInner)((Object)this.serviceManager.serviceClient().getSapCentralServerInstances().getWithResponse(this.resourceGroupName, this.sapVirtualInstanceName, this.centralInstanceName, context).getValue());
        return this;
    }

    @Override
    public OperationStatusResult start() {
        return this.serviceManager.sapCentralServerInstances().start(this.resourceGroupName, this.sapVirtualInstanceName, this.centralInstanceName);
    }

    @Override
    public OperationStatusResult start(StartRequest body, Context context) {
        return this.serviceManager.sapCentralServerInstances().start(this.resourceGroupName, this.sapVirtualInstanceName, this.centralInstanceName, body, context);
    }

    @Override
    public OperationStatusResult stop() {
        return this.serviceManager.sapCentralServerInstances().stop(this.resourceGroupName, this.sapVirtualInstanceName, this.centralInstanceName);
    }

    @Override
    public OperationStatusResult stop(StopRequest body, Context context) {
        return this.serviceManager.sapCentralServerInstances().stop(this.resourceGroupName, this.sapVirtualInstanceName, this.centralInstanceName, body, context);
    }

    @Override
    public SapCentralServerInstanceImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public SapCentralServerInstanceImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public SapCentralServerInstanceImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateProperties.withTags(tags);
        return this;
    }

    @Override
    public SapCentralServerInstanceImpl withProperties(SapCentralServerProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

