/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.models;

import com.azure.core.management.exception.ManagementError;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.models.ValidationStatus;
import java.io.IOException;

public final class UpdateExternalValidationStatusParameter
implements JsonSerializable<UpdateExternalValidationStatusParameter> {
    private String solutionVersionId;
    private ManagementError errorDetails;
    private String externalValidationId;
    private ValidationStatus validationStatus;
    private static final ClientLogger LOGGER = new ClientLogger(UpdateExternalValidationStatusParameter.class);

    public String solutionVersionId() {
        return this.solutionVersionId;
    }

    public UpdateExternalValidationStatusParameter withSolutionVersionId(String solutionVersionId) {
        this.solutionVersionId = solutionVersionId;
        return this;
    }

    public ManagementError errorDetails() {
        return this.errorDetails;
    }

    public UpdateExternalValidationStatusParameter withErrorDetails(ManagementError errorDetails) {
        this.errorDetails = errorDetails;
        return this;
    }

    public String externalValidationId() {
        return this.externalValidationId;
    }

    public UpdateExternalValidationStatusParameter withExternalValidationId(String externalValidationId) {
        this.externalValidationId = externalValidationId;
        return this;
    }

    public ValidationStatus validationStatus() {
        return this.validationStatus;
    }

    public UpdateExternalValidationStatusParameter withValidationStatus(ValidationStatus validationStatus) {
        this.validationStatus = validationStatus;
        return this;
    }

    public void validate() {
        if (this.solutionVersionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property solutionVersionId in model UpdateExternalValidationStatusParameter"));
        }
        if (this.externalValidationId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property externalValidationId in model UpdateExternalValidationStatusParameter"));
        }
        if (this.validationStatus() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property validationStatus in model UpdateExternalValidationStatusParameter"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("solutionVersionId", this.solutionVersionId);
        jsonWriter.writeStringField("externalValidationId", this.externalValidationId);
        jsonWriter.writeStringField("validationStatus", this.validationStatus == null ? null : this.validationStatus.toString());
        jsonWriter.writeJsonField("errorDetails", (JsonSerializable)this.errorDetails);
        return jsonWriter.writeEndObject();
    }

    public static UpdateExternalValidationStatusParameter fromJson(JsonReader jsonReader) throws IOException {
        return (UpdateExternalValidationStatusParameter)jsonReader.readObject(reader -> {
            UpdateExternalValidationStatusParameter deserializedUpdateExternalValidationStatusParameter = new UpdateExternalValidationStatusParameter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("solutionVersionId".equals(fieldName)) {
                    deserializedUpdateExternalValidationStatusParameter.solutionVersionId = reader.getString();
                    continue;
                }
                if ("externalValidationId".equals(fieldName)) {
                    deserializedUpdateExternalValidationStatusParameter.externalValidationId = reader.getString();
                    continue;
                }
                if ("validationStatus".equals(fieldName)) {
                    deserializedUpdateExternalValidationStatusParameter.validationStatus = ValidationStatus.fromString(reader.getString());
                    continue;
                }
                if ("errorDetails".equals(fieldName)) {
                    deserializedUpdateExternalValidationStatusParameter.errorDetails = ManagementError.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUpdateExternalValidationStatusParameter;
        });
    }
}

