/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.models.ComponentStatus;
import java.io.IOException;
import java.util.List;

public final class TargetStatus
implements JsonSerializable<TargetStatus> {
    private String name;
    private String status;
    private List<ComponentStatus> componentStatuses;

    private TargetStatus() {
    }

    public String name() {
        return this.name;
    }

    public String status() {
        return this.status;
    }

    public List<ComponentStatus> componentStatuses() {
        return this.componentStatuses;
    }

    public void validate() {
        if (this.componentStatuses() != null) {
            this.componentStatuses().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("status", this.status);
        jsonWriter.writeArrayField("componentStatuses", this.componentStatuses, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static TargetStatus fromJson(JsonReader jsonReader) throws IOException {
        return (TargetStatus)jsonReader.readObject(reader -> {
            TargetStatus deserializedTargetStatus = new TargetStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedTargetStatus.name = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedTargetStatus.status = reader.getString();
                    continue;
                }
                if ("componentStatuses".equals(fieldName)) {
                    List componentStatuses;
                    deserializedTargetStatus.componentStatuses = componentStatuses = reader.readArray(reader1 -> ComponentStatus.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTargetStatus;
        });
    }
}

