/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.models;

import com.azure.core.util.BinaryData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.models.DeploymentStatus;
import com.azure.resourcemanager.workloadorchestration.models.ProvisioningState;
import com.azure.resourcemanager.workloadorchestration.models.ResourceState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class TargetProperties
implements JsonSerializable<TargetProperties> {
    private String description;
    private String displayName;
    private String contextId;
    private Map<String, BinaryData> targetSpecification;
    private List<String> capabilities;
    private String hierarchyLevel;
    private DeploymentStatus status;
    private String solutionScope;
    private ResourceState state;
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(TargetProperties.class);

    public String description() {
        return this.description;
    }

    public TargetProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public TargetProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String contextId() {
        return this.contextId;
    }

    public TargetProperties withContextId(String contextId) {
        this.contextId = contextId;
        return this;
    }

    public Map<String, BinaryData> targetSpecification() {
        return this.targetSpecification;
    }

    public TargetProperties withTargetSpecification(Map<String, BinaryData> targetSpecification) {
        this.targetSpecification = targetSpecification;
        return this;
    }

    public List<String> capabilities() {
        return this.capabilities;
    }

    public TargetProperties withCapabilities(List<String> capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public String hierarchyLevel() {
        return this.hierarchyLevel;
    }

    public TargetProperties withHierarchyLevel(String hierarchyLevel) {
        this.hierarchyLevel = hierarchyLevel;
        return this;
    }

    public DeploymentStatus status() {
        return this.status;
    }

    public String solutionScope() {
        return this.solutionScope;
    }

    public TargetProperties withSolutionScope(String solutionScope) {
        this.solutionScope = solutionScope;
        return this;
    }

    public ResourceState state() {
        return this.state;
    }

    public TargetProperties withState(ResourceState state) {
        this.state = state;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.description() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property description in model TargetProperties"));
        }
        if (this.displayName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property displayName in model TargetProperties"));
        }
        if (this.contextId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property contextId in model TargetProperties"));
        }
        if (this.targetSpecification() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targetSpecification in model TargetProperties"));
        }
        if (this.capabilities() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property capabilities in model TargetProperties"));
        }
        if (this.hierarchyLevel() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property hierarchyLevel in model TargetProperties"));
        }
        if (this.status() != null) {
            this.status().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("contextId", this.contextId);
        jsonWriter.writeMapField("targetSpecification", this.targetSpecification, (writer, element) -> writer.writeUntyped(element == null ? null : element.toObject(Object.class)));
        jsonWriter.writeArrayField("capabilities", this.capabilities, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("hierarchyLevel", this.hierarchyLevel);
        jsonWriter.writeStringField("solutionScope", this.solutionScope);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        return jsonWriter.writeEndObject();
    }

    public static TargetProperties fromJson(JsonReader jsonReader) throws IOException {
        return (TargetProperties)jsonReader.readObject(reader -> {
            TargetProperties deserializedTargetProperties = new TargetProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedTargetProperties.description = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedTargetProperties.displayName = reader.getString();
                    continue;
                }
                if ("contextId".equals(fieldName)) {
                    deserializedTargetProperties.contextId = reader.getString();
                    continue;
                }
                if ("targetSpecification".equals(fieldName)) {
                    Map targetSpecification;
                    deserializedTargetProperties.targetSpecification = targetSpecification = reader.readMap(reader1 -> (BinaryData)reader1.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped())));
                    continue;
                }
                if ("capabilities".equals(fieldName)) {
                    List capabilities;
                    deserializedTargetProperties.capabilities = capabilities = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("hierarchyLevel".equals(fieldName)) {
                    deserializedTargetProperties.hierarchyLevel = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedTargetProperties.status = DeploymentStatus.fromJson(reader);
                    continue;
                }
                if ("solutionScope".equals(fieldName)) {
                    deserializedTargetProperties.solutionScope = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedTargetProperties.state = ResourceState.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedTargetProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTargetProperties;
        });
    }
}

