/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.workloadorchestration.fluent.models.TargetInner;
import com.azure.resourcemanager.workloadorchestration.models.ExtendedLocation;
import com.azure.resourcemanager.workloadorchestration.models.InstallSolutionParameter;
import com.azure.resourcemanager.workloadorchestration.models.RemoveRevisionParameter;
import com.azure.resourcemanager.workloadorchestration.models.ResolvedConfiguration;
import com.azure.resourcemanager.workloadorchestration.models.SolutionTemplateParameter;
import com.azure.resourcemanager.workloadorchestration.models.SolutionVersion;
import com.azure.resourcemanager.workloadorchestration.models.SolutionVersionParameter;
import com.azure.resourcemanager.workloadorchestration.models.TargetProperties;
import com.azure.resourcemanager.workloadorchestration.models.UninstallSolutionParameter;
import com.azure.resourcemanager.workloadorchestration.models.UpdateExternalValidationStatusParameter;
import java.util.Map;

public interface Target {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public TargetProperties properties();

    public String eTag();

    public ExtendedLocation extendedLocation();

    public SystemData systemData();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public TargetInner innerModel();

    public Update update();

    public Target refresh();

    public Target refresh(Context var1);

    public void installSolution(InstallSolutionParameter var1);

    public void installSolution(InstallSolutionParameter var1, Context var2);

    public void uninstallSolution(UninstallSolutionParameter var1);

    public void uninstallSolution(UninstallSolutionParameter var1, Context var2);

    public void removeRevision(RemoveRevisionParameter var1);

    public void removeRevision(RemoveRevisionParameter var1, Context var2);

    public ResolvedConfiguration resolveConfiguration(SolutionTemplateParameter var1);

    public ResolvedConfiguration resolveConfiguration(SolutionTemplateParameter var1, Context var2);

    public SolutionVersion reviewSolutionVersion(SolutionTemplateParameter var1);

    public SolutionVersion reviewSolutionVersion(SolutionTemplateParameter var1, Context var2);

    public SolutionVersion publishSolutionVersion(SolutionVersionParameter var1);

    public SolutionVersion publishSolutionVersion(SolutionVersionParameter var1, Context var2);

    public SolutionVersion updateExternalValidationStatus(UpdateExternalValidationStatusParameter var1);

    public SolutionVersion updateExternalValidationStatus(UpdateExternalValidationStatusParameter var1, Context var2);

    public static interface UpdateStages {

        public static interface WithProperties {
            public Update withProperties(TargetProperties var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithProperties {
        public Target apply();

        public Target apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithExtendedLocation {
            public WithCreate withExtendedLocation(ExtendedLocation var1);
        }

        public static interface WithProperties {
            public WithCreate withProperties(TargetProperties var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithProperties,
        WithExtendedLocation {
            public Target create();

            public Target create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

