/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.models;

import com.azure.core.management.exception.ManagementError;
import com.azure.core.util.BinaryData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.models.JobType;
import com.azure.resourcemanager.workloadorchestration.models.ProvisioningState;
import com.azure.resourcemanager.workloadorchestration.models.SolutionDependency;
import com.azure.resourcemanager.workloadorchestration.models.State;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class SolutionVersionProperties
implements JsonSerializable<SolutionVersionProperties> {
    private String solutionTemplateVersionId;
    private Integer revision;
    private String targetDisplayName;
    private String configuration;
    private String targetLevelConfiguration;
    private Map<String, BinaryData> specification;
    private String reviewId;
    private String externalValidationId;
    private State state;
    private String solutionInstanceName;
    private List<SolutionDependency> solutionDependencies;
    private ManagementError errorDetails;
    private String latestActionTrackingUri;
    private JobType actionType;
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(SolutionVersionProperties.class);

    public String solutionTemplateVersionId() {
        return this.solutionTemplateVersionId;
    }

    public Integer revision() {
        return this.revision;
    }

    public String targetDisplayName() {
        return this.targetDisplayName;
    }

    public String configuration() {
        return this.configuration;
    }

    public String targetLevelConfiguration() {
        return this.targetLevelConfiguration;
    }

    public Map<String, BinaryData> specification() {
        return this.specification;
    }

    public SolutionVersionProperties withSpecification(Map<String, BinaryData> specification) {
        this.specification = specification;
        return this;
    }

    public String reviewId() {
        return this.reviewId;
    }

    public String externalValidationId() {
        return this.externalValidationId;
    }

    public State state() {
        return this.state;
    }

    public String solutionInstanceName() {
        return this.solutionInstanceName;
    }

    public List<SolutionDependency> solutionDependencies() {
        return this.solutionDependencies;
    }

    public ManagementError errorDetails() {
        return this.errorDetails;
    }

    public String latestActionTrackingUri() {
        return this.latestActionTrackingUri;
    }

    public JobType actionType() {
        return this.actionType;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.specification() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property specification in model SolutionVersionProperties"));
        }
        if (this.solutionDependencies() != null) {
            this.solutionDependencies().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("specification", this.specification, (writer, element) -> writer.writeUntyped(element == null ? null : element.toObject(Object.class)));
        return jsonWriter.writeEndObject();
    }

    public static SolutionVersionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SolutionVersionProperties)jsonReader.readObject(reader -> {
            SolutionVersionProperties deserializedSolutionVersionProperties = new SolutionVersionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("specification".equals(fieldName)) {
                    Map specification;
                    deserializedSolutionVersionProperties.specification = specification = reader.readMap(reader1 -> (BinaryData)reader1.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped())));
                    continue;
                }
                if ("solutionTemplateVersionId".equals(fieldName)) {
                    deserializedSolutionVersionProperties.solutionTemplateVersionId = reader.getString();
                    continue;
                }
                if ("revision".equals(fieldName)) {
                    deserializedSolutionVersionProperties.revision = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("targetDisplayName".equals(fieldName)) {
                    deserializedSolutionVersionProperties.targetDisplayName = reader.getString();
                    continue;
                }
                if ("configuration".equals(fieldName)) {
                    deserializedSolutionVersionProperties.configuration = reader.getString();
                    continue;
                }
                if ("targetLevelConfiguration".equals(fieldName)) {
                    deserializedSolutionVersionProperties.targetLevelConfiguration = reader.getString();
                    continue;
                }
                if ("reviewId".equals(fieldName)) {
                    deserializedSolutionVersionProperties.reviewId = reader.getString();
                    continue;
                }
                if ("externalValidationId".equals(fieldName)) {
                    deserializedSolutionVersionProperties.externalValidationId = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedSolutionVersionProperties.state = State.fromString(reader.getString());
                    continue;
                }
                if ("solutionInstanceName".equals(fieldName)) {
                    deserializedSolutionVersionProperties.solutionInstanceName = reader.getString();
                    continue;
                }
                if ("solutionDependencies".equals(fieldName)) {
                    List solutionDependencies;
                    deserializedSolutionVersionProperties.solutionDependencies = solutionDependencies = reader.readArray(reader1 -> SolutionDependency.fromJson(reader1));
                    continue;
                }
                if ("errorDetails".equals(fieldName)) {
                    deserializedSolutionVersionProperties.errorDetails = ManagementError.fromJson((JsonReader)reader);
                    continue;
                }
                if ("latestActionTrackingUri".equals(fieldName)) {
                    deserializedSolutionVersionProperties.latestActionTrackingUri = reader.getString();
                    continue;
                }
                if ("actionType".equals(fieldName)) {
                    deserializedSolutionVersionProperties.actionType = JobType.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedSolutionVersionProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSolutionVersionProperties;
        });
    }
}

