/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.models.AvailableSolutionTemplateVersion;
import com.azure.resourcemanager.workloadorchestration.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class SolutionProperties
implements JsonSerializable<SolutionProperties> {
    private String solutionTemplateId;
    private List<AvailableSolutionTemplateVersion> availableSolutionTemplateVersions;
    private ProvisioningState provisioningState;

    public String solutionTemplateId() {
        return this.solutionTemplateId;
    }

    public List<AvailableSolutionTemplateVersion> availableSolutionTemplateVersions() {
        return this.availableSolutionTemplateVersions;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.availableSolutionTemplateVersions() != null) {
            this.availableSolutionTemplateVersions().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static SolutionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SolutionProperties)jsonReader.readObject(reader -> {
            SolutionProperties deserializedSolutionProperties = new SolutionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("solutionTemplateId".equals(fieldName)) {
                    deserializedSolutionProperties.solutionTemplateId = reader.getString();
                    continue;
                }
                if ("availableSolutionTemplateVersions".equals(fieldName)) {
                    List availableSolutionTemplateVersions;
                    deserializedSolutionProperties.availableSolutionTemplateVersions = availableSolutionTemplateVersions = reader.readArray(reader1 -> AvailableSolutionTemplateVersion.fromJson(reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedSolutionProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSolutionProperties;
        });
    }
}

