/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class SolutionDependencyParameter
implements JsonSerializable<SolutionDependencyParameter> {
    private String solutionVersionId;
    private String solutionTemplateId;
    private String solutionTemplateVersion;
    private String solutionInstanceName;
    private String targetId;
    private List<SolutionDependencyParameter> dependencies;

    public String solutionVersionId() {
        return this.solutionVersionId;
    }

    public SolutionDependencyParameter withSolutionVersionId(String solutionVersionId) {
        this.solutionVersionId = solutionVersionId;
        return this;
    }

    public String solutionTemplateId() {
        return this.solutionTemplateId;
    }

    public SolutionDependencyParameter withSolutionTemplateId(String solutionTemplateId) {
        this.solutionTemplateId = solutionTemplateId;
        return this;
    }

    public String solutionTemplateVersion() {
        return this.solutionTemplateVersion;
    }

    public SolutionDependencyParameter withSolutionTemplateVersion(String solutionTemplateVersion) {
        this.solutionTemplateVersion = solutionTemplateVersion;
        return this;
    }

    public String solutionInstanceName() {
        return this.solutionInstanceName;
    }

    public SolutionDependencyParameter withSolutionInstanceName(String solutionInstanceName) {
        this.solutionInstanceName = solutionInstanceName;
        return this;
    }

    public String targetId() {
        return this.targetId;
    }

    public SolutionDependencyParameter withTargetId(String targetId) {
        this.targetId = targetId;
        return this;
    }

    public List<SolutionDependencyParameter> dependencies() {
        return this.dependencies;
    }

    public SolutionDependencyParameter withDependencies(List<SolutionDependencyParameter> dependencies) {
        this.dependencies = dependencies;
        return this;
    }

    public void validate() {
        if (this.dependencies() != null) {
            this.dependencies().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("solutionVersionId", this.solutionVersionId);
        jsonWriter.writeStringField("solutionTemplateId", this.solutionTemplateId);
        jsonWriter.writeStringField("solutionTemplateVersion", this.solutionTemplateVersion);
        jsonWriter.writeStringField("solutionInstanceName", this.solutionInstanceName);
        jsonWriter.writeStringField("targetId", this.targetId);
        jsonWriter.writeArrayField("dependencies", this.dependencies, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SolutionDependencyParameter fromJson(JsonReader jsonReader) throws IOException {
        return (SolutionDependencyParameter)jsonReader.readObject(reader -> {
            SolutionDependencyParameter deserializedSolutionDependencyParameter = new SolutionDependencyParameter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("solutionVersionId".equals(fieldName)) {
                    deserializedSolutionDependencyParameter.solutionVersionId = reader.getString();
                    continue;
                }
                if ("solutionTemplateId".equals(fieldName)) {
                    deserializedSolutionDependencyParameter.solutionTemplateId = reader.getString();
                    continue;
                }
                if ("solutionTemplateVersion".equals(fieldName)) {
                    deserializedSolutionDependencyParameter.solutionTemplateVersion = reader.getString();
                    continue;
                }
                if ("solutionInstanceName".equals(fieldName)) {
                    deserializedSolutionDependencyParameter.solutionInstanceName = reader.getString();
                    continue;
                }
                if ("targetId".equals(fieldName)) {
                    deserializedSolutionDependencyParameter.targetId = reader.getString();
                    continue;
                }
                if ("dependencies".equals(fieldName)) {
                    List dependencies;
                    deserializedSolutionDependencyParameter.dependencies = dependencies = reader.readArray(reader1 -> SolutionDependencyParameter.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSolutionDependencyParameter;
        });
    }
}

