/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class SolutionDependency
implements JsonSerializable<SolutionDependency> {
    private String solutionVersionId;
    private String solutionInstanceName;
    private String solutionTemplateVersionId;
    private String targetId;
    private List<SolutionDependency> dependencies;
    private static final ClientLogger LOGGER = new ClientLogger(SolutionDependency.class);

    private SolutionDependency() {
    }

    public String solutionVersionId() {
        return this.solutionVersionId;
    }

    public String solutionInstanceName() {
        return this.solutionInstanceName;
    }

    public String solutionTemplateVersionId() {
        return this.solutionTemplateVersionId;
    }

    public String targetId() {
        return this.targetId;
    }

    public List<SolutionDependency> dependencies() {
        return this.dependencies;
    }

    public void validate() {
        if (this.solutionVersionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property solutionVersionId in model SolutionDependency"));
        }
        if (this.solutionTemplateVersionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property solutionTemplateVersionId in model SolutionDependency"));
        }
        if (this.targetId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targetId in model SolutionDependency"));
        }
        if (this.dependencies() != null) {
            this.dependencies().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("solutionVersionId", this.solutionVersionId);
        jsonWriter.writeStringField("solutionTemplateVersionId", this.solutionTemplateVersionId);
        jsonWriter.writeStringField("targetId", this.targetId);
        jsonWriter.writeStringField("solutionInstanceName", this.solutionInstanceName);
        jsonWriter.writeArrayField("dependencies", this.dependencies, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SolutionDependency fromJson(JsonReader jsonReader) throws IOException {
        return (SolutionDependency)jsonReader.readObject(reader -> {
            SolutionDependency deserializedSolutionDependency = new SolutionDependency();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("solutionVersionId".equals(fieldName)) {
                    deserializedSolutionDependency.solutionVersionId = reader.getString();
                    continue;
                }
                if ("solutionTemplateVersionId".equals(fieldName)) {
                    deserializedSolutionDependency.solutionTemplateVersionId = reader.getString();
                    continue;
                }
                if ("targetId".equals(fieldName)) {
                    deserializedSolutionDependency.targetId = reader.getString();
                    continue;
                }
                if ("solutionInstanceName".equals(fieldName)) {
                    deserializedSolutionDependency.solutionInstanceName = reader.getString();
                    continue;
                }
                if ("dependencies".equals(fieldName)) {
                    List dependencies;
                    deserializedSolutionDependency.dependencies = dependencies = reader.readArray(reader1 -> SolutionDependency.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSolutionDependency;
        });
    }
}

