/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.models.ProvisioningState;
import java.io.IOException;

public final class SiteReferenceProperties
implements JsonSerializable<SiteReferenceProperties> {
    private String siteId;
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(SiteReferenceProperties.class);

    public String siteId() {
        return this.siteId;
    }

    public SiteReferenceProperties withSiteId(String siteId) {
        this.siteId = siteId;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.siteId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property siteId in model SiteReferenceProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("siteId", this.siteId);
        return jsonWriter.writeEndObject();
    }

    public static SiteReferenceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SiteReferenceProperties)jsonReader.readObject(reader -> {
            SiteReferenceProperties deserializedSiteReferenceProperties = new SiteReferenceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("siteId".equals(fieldName)) {
                    deserializedSiteReferenceProperties.siteId = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedSiteReferenceProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSiteReferenceProperties;
        });
    }
}

