/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.models.ProvisioningState;
import java.io.IOException;

public final class SchemaReferenceProperties
implements JsonSerializable<SchemaReferenceProperties> {
    private String schemaId;
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(SchemaReferenceProperties.class);

    private SchemaReferenceProperties() {
    }

    public String schemaId() {
        return this.schemaId;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.schemaId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property schemaId in model SchemaReferenceProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("schemaId", this.schemaId);
        return jsonWriter.writeEndObject();
    }

    public static SchemaReferenceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SchemaReferenceProperties)jsonReader.readObject(reader -> {
            SchemaReferenceProperties deserializedSchemaReferenceProperties = new SchemaReferenceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("schemaId".equals(fieldName)) {
                    deserializedSchemaReferenceProperties.schemaId = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedSchemaReferenceProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSchemaReferenceProperties;
        });
    }
}

