/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.models;

import com.azure.core.management.exception.ManagementError;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.models.JobParameterBase;
import com.azure.resourcemanager.workloadorchestration.models.JobStatus;
import com.azure.resourcemanager.workloadorchestration.models.JobStep;
import com.azure.resourcemanager.workloadorchestration.models.JobType;
import com.azure.resourcemanager.workloadorchestration.models.ProvisioningState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class JobProperties
implements JsonSerializable<JobProperties> {
    private JobType jobType;
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private JobStatus status;
    private JobParameterBase jobParameter;
    private String correlationId;
    private List<JobStep> steps;
    private String triggeredBy;
    private ProvisioningState provisioningState;
    private ManagementError errorDetails;
    private static final ClientLogger LOGGER = new ClientLogger(JobProperties.class);

    private JobProperties() {
    }

    public JobType jobType() {
        return this.jobType;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public JobStatus status() {
        return this.status;
    }

    public JobParameterBase jobParameter() {
        return this.jobParameter;
    }

    public String correlationId() {
        return this.correlationId;
    }

    public List<JobStep> steps() {
        return this.steps;
    }

    public String triggeredBy() {
        return this.triggeredBy;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public ManagementError errorDetails() {
        return this.errorDetails;
    }

    public void validate() {
        if (this.jobType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property jobType in model JobProperties"));
        }
        if (this.status() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property status in model JobProperties"));
        }
        if (this.jobParameter() != null) {
            this.jobParameter().validate();
        }
        if (this.steps() != null) {
            this.steps().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("jobType", this.jobType == null ? null : this.jobType.toString());
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeJsonField("jobParameter", (JsonSerializable)this.jobParameter);
        jsonWriter.writeStringField("correlationId", this.correlationId);
        jsonWriter.writeArrayField("steps", this.steps, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("triggeredBy", this.triggeredBy);
        return jsonWriter.writeEndObject();
    }

    public static JobProperties fromJson(JsonReader jsonReader) throws IOException {
        return (JobProperties)jsonReader.readObject(reader -> {
            JobProperties deserializedJobProperties = new JobProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("jobType".equals(fieldName)) {
                    deserializedJobProperties.jobType = JobType.fromString(reader.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedJobProperties.status = JobStatus.fromString(reader.getString());
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedJobProperties.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedJobProperties.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("jobParameter".equals(fieldName)) {
                    deserializedJobProperties.jobParameter = JobParameterBase.fromJson(reader);
                    continue;
                }
                if ("correlationId".equals(fieldName)) {
                    deserializedJobProperties.correlationId = reader.getString();
                    continue;
                }
                if ("steps".equals(fieldName)) {
                    List steps;
                    deserializedJobProperties.steps = steps = reader.readArray(reader1 -> JobStep.fromJson(reader1));
                    continue;
                }
                if ("triggeredBy".equals(fieldName)) {
                    deserializedJobProperties.triggeredBy = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedJobProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("errorDetails".equals(fieldName)) {
                    deserializedJobProperties.errorDetails = ManagementError.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobProperties;
        });
    }
}

