/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.models.ActiveState;
import com.azure.resourcemanager.workloadorchestration.models.DeploymentStatus;
import com.azure.resourcemanager.workloadorchestration.models.ProvisioningState;
import com.azure.resourcemanager.workloadorchestration.models.ReconciliationPolicyProperties;
import java.io.IOException;

public final class InstanceProperties
implements JsonSerializable<InstanceProperties> {
    private String solutionVersionId;
    private String targetId;
    private ActiveState activeState;
    private ReconciliationPolicyProperties reconciliationPolicy;
    private String solutionScope;
    private DeploymentStatus status;
    private Long deploymentTimestampEpoch;
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(InstanceProperties.class);

    public String solutionVersionId() {
        return this.solutionVersionId;
    }

    public InstanceProperties withSolutionVersionId(String solutionVersionId) {
        this.solutionVersionId = solutionVersionId;
        return this;
    }

    public String targetId() {
        return this.targetId;
    }

    public InstanceProperties withTargetId(String targetId) {
        this.targetId = targetId;
        return this;
    }

    public ActiveState activeState() {
        return this.activeState;
    }

    public InstanceProperties withActiveState(ActiveState activeState) {
        this.activeState = activeState;
        return this;
    }

    public ReconciliationPolicyProperties reconciliationPolicy() {
        return this.reconciliationPolicy;
    }

    public InstanceProperties withReconciliationPolicy(ReconciliationPolicyProperties reconciliationPolicy) {
        this.reconciliationPolicy = reconciliationPolicy;
        return this;
    }

    public String solutionScope() {
        return this.solutionScope;
    }

    public InstanceProperties withSolutionScope(String solutionScope) {
        this.solutionScope = solutionScope;
        return this;
    }

    public DeploymentStatus status() {
        return this.status;
    }

    public Long deploymentTimestampEpoch() {
        return this.deploymentTimestampEpoch;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.solutionVersionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property solutionVersionId in model InstanceProperties"));
        }
        if (this.targetId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targetId in model InstanceProperties"));
        }
        if (this.reconciliationPolicy() != null) {
            this.reconciliationPolicy().validate();
        }
        if (this.status() != null) {
            this.status().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("solutionVersionId", this.solutionVersionId);
        jsonWriter.writeStringField("targetId", this.targetId);
        jsonWriter.writeStringField("activeState", this.activeState == null ? null : this.activeState.toString());
        jsonWriter.writeJsonField("reconciliationPolicy", (JsonSerializable)this.reconciliationPolicy);
        jsonWriter.writeStringField("solutionScope", this.solutionScope);
        return jsonWriter.writeEndObject();
    }

    public static InstanceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (InstanceProperties)jsonReader.readObject(reader -> {
            InstanceProperties deserializedInstanceProperties = new InstanceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("solutionVersionId".equals(fieldName)) {
                    deserializedInstanceProperties.solutionVersionId = reader.getString();
                    continue;
                }
                if ("targetId".equals(fieldName)) {
                    deserializedInstanceProperties.targetId = reader.getString();
                    continue;
                }
                if ("activeState".equals(fieldName)) {
                    deserializedInstanceProperties.activeState = ActiveState.fromString(reader.getString());
                    continue;
                }
                if ("reconciliationPolicy".equals(fieldName)) {
                    deserializedInstanceProperties.reconciliationPolicy = ReconciliationPolicyProperties.fromJson(reader);
                    continue;
                }
                if ("solutionScope".equals(fieldName)) {
                    deserializedInstanceProperties.solutionScope = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedInstanceProperties.status = DeploymentStatus.fromJson(reader);
                    continue;
                }
                if ("deploymentTimestampEpoch".equals(fieldName)) {
                    deserializedInstanceProperties.deploymentTimestampEpoch = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedInstanceProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedInstanceProperties;
        });
    }
}

