/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class Hierarchy
implements JsonSerializable<Hierarchy> {
    private String name;
    private String description;
    private static final ClientLogger LOGGER = new ClientLogger(Hierarchy.class);

    public String name() {
        return this.name;
    }

    public Hierarchy withName(String name) {
        this.name = name;
        return this;
    }

    public String description() {
        return this.description;
    }

    public Hierarchy withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model Hierarchy"));
        }
        if (this.description() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property description in model Hierarchy"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static Hierarchy fromJson(JsonReader jsonReader) throws IOException {
        return (Hierarchy)jsonReader.readObject(reader -> {
            Hierarchy deserializedHierarchy = new Hierarchy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedHierarchy.name = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedHierarchy.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHierarchy;
        });
    }
}

