/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.models.StageStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class ExecutionStatus
implements JsonSerializable<ExecutionStatus> {
    private OffsetDateTime updateTime;
    private Integer status;
    private String statusMessage;
    private List<StageStatus> stageHistory;

    private ExecutionStatus() {
    }

    public OffsetDateTime updateTime() {
        return this.updateTime;
    }

    public Integer status() {
        return this.status;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public List<StageStatus> stageHistory() {
        return this.stageHistory;
    }

    public void validate() {
        if (this.stageHistory() != null) {
            this.stageHistory().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("updateTime", this.updateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.updateTime));
        jsonWriter.writeNumberField("status", (Number)this.status);
        jsonWriter.writeStringField("statusMessage", this.statusMessage);
        jsonWriter.writeArrayField("stageHistory", this.stageHistory, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ExecutionStatus fromJson(JsonReader jsonReader) throws IOException {
        return (ExecutionStatus)jsonReader.readObject(reader -> {
            ExecutionStatus deserializedExecutionStatus = new ExecutionStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("updateTime".equals(fieldName)) {
                    deserializedExecutionStatus.updateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedExecutionStatus.status = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("statusMessage".equals(fieldName)) {
                    deserializedExecutionStatus.statusMessage = reader.getString();
                    continue;
                }
                if ("stageHistory".equals(fieldName)) {
                    List stageHistory;
                    deserializedExecutionStatus.stageHistory = stageHistory = reader.readArray(reader1 -> StageStatus.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExecutionStatus;
        });
    }
}

