/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.models.ErrorActionMode;
import java.io.IOException;

public final class ErrorAction
implements JsonSerializable<ErrorAction> {
    private ErrorActionMode mode;
    private Integer maxToleratedFailures;

    public ErrorActionMode mode() {
        return this.mode;
    }

    public ErrorAction withMode(ErrorActionMode mode) {
        this.mode = mode;
        return this;
    }

    public Integer maxToleratedFailures() {
        return this.maxToleratedFailures;
    }

    public ErrorAction withMaxToleratedFailures(Integer maxToleratedFailures) {
        this.maxToleratedFailures = maxToleratedFailures;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("mode", this.mode == null ? null : this.mode.toString());
        jsonWriter.writeNumberField("maxToleratedFailures", (Number)this.maxToleratedFailures);
        return jsonWriter.writeEndObject();
    }

    public static ErrorAction fromJson(JsonReader jsonReader) throws IOException {
        return (ErrorAction)jsonReader.readObject(reader -> {
            ErrorAction deserializedErrorAction = new ErrorAction();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("mode".equals(fieldName)) {
                    deserializedErrorAction.mode = ErrorActionMode.fromString(reader.getString());
                    continue;
                }
                if ("maxToleratedFailures".equals(fieldName)) {
                    deserializedErrorAction.maxToleratedFailures = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedErrorAction;
        });
    }
}

