/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.models.TargetStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class DeploymentStatus
implements JsonSerializable<DeploymentStatus> {
    private OffsetDateTime lastModified;
    private Integer deployed;
    private Integer expectedRunningJobId;
    private Integer runningJobId;
    private String status;
    private String statusDetails;
    private Integer generation;
    private List<TargetStatus> targetStatuses;

    private DeploymentStatus() {
    }

    public OffsetDateTime lastModified() {
        return this.lastModified;
    }

    public Integer deployed() {
        return this.deployed;
    }

    public Integer expectedRunningJobId() {
        return this.expectedRunningJobId;
    }

    public Integer runningJobId() {
        return this.runningJobId;
    }

    public String status() {
        return this.status;
    }

    public String statusDetails() {
        return this.statusDetails;
    }

    public Integer generation() {
        return this.generation;
    }

    public List<TargetStatus> targetStatuses() {
        return this.targetStatuses;
    }

    public void validate() {
        if (this.targetStatuses() != null) {
            this.targetStatuses().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("lastModified", this.lastModified == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModified));
        jsonWriter.writeNumberField("deployed", (Number)this.deployed);
        jsonWriter.writeNumberField("expectedRunningJobId", (Number)this.expectedRunningJobId);
        jsonWriter.writeNumberField("runningJobId", (Number)this.runningJobId);
        jsonWriter.writeStringField("status", this.status);
        jsonWriter.writeStringField("statusDetails", this.statusDetails);
        jsonWriter.writeNumberField("generation", (Number)this.generation);
        jsonWriter.writeArrayField("targetStatuses", this.targetStatuses, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DeploymentStatus fromJson(JsonReader jsonReader) throws IOException {
        return (DeploymentStatus)jsonReader.readObject(reader -> {
            DeploymentStatus deserializedDeploymentStatus = new DeploymentStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("lastModified".equals(fieldName)) {
                    deserializedDeploymentStatus.lastModified = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("deployed".equals(fieldName)) {
                    deserializedDeploymentStatus.deployed = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("expectedRunningJobId".equals(fieldName)) {
                    deserializedDeploymentStatus.expectedRunningJobId = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("runningJobId".equals(fieldName)) {
                    deserializedDeploymentStatus.runningJobId = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedDeploymentStatus.status = reader.getString();
                    continue;
                }
                if ("statusDetails".equals(fieldName)) {
                    deserializedDeploymentStatus.statusDetails = reader.getString();
                    continue;
                }
                if ("generation".equals(fieldName)) {
                    deserializedDeploymentStatus.generation = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("targetStatuses".equals(fieldName)) {
                    List targetStatuses;
                    deserializedDeploymentStatus.targetStatuses = targetStatuses = reader.readArray(reader1 -> TargetStatus.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeploymentStatus;
        });
    }
}

