/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.models.ResourceState;
import java.io.IOException;

public final class Capability
implements JsonSerializable<Capability> {
    private String name;
    private String description;
    private ResourceState state;
    private static final ClientLogger LOGGER = new ClientLogger(Capability.class);

    public String name() {
        return this.name;
    }

    public Capability withName(String name) {
        this.name = name;
        return this;
    }

    public String description() {
        return this.description;
    }

    public Capability withDescription(String description) {
        this.description = description;
        return this;
    }

    public ResourceState state() {
        return this.state;
    }

    public Capability withState(ResourceState state) {
        this.state = state;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model Capability"));
        }
        if (this.description() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property description in model Capability"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        return jsonWriter.writeEndObject();
    }

    public static Capability fromJson(JsonReader jsonReader) throws IOException {
        return (Capability)jsonReader.readObject(reader -> {
            Capability deserializedCapability = new Capability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedCapability.name = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedCapability.description = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedCapability.state = ResourceState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCapability;
        });
    }
}

