/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.models.BulkDeployTargetDetails;
import java.io.IOException;
import java.util.List;

public final class BulkDeploySolutionParameter
implements JsonSerializable<BulkDeploySolutionParameter> {
    private List<BulkDeployTargetDetails> targets;
    private static final ClientLogger LOGGER = new ClientLogger(BulkDeploySolutionParameter.class);

    public List<BulkDeployTargetDetails> targets() {
        return this.targets;
    }

    public BulkDeploySolutionParameter withTargets(List<BulkDeployTargetDetails> targets) {
        this.targets = targets;
        return this;
    }

    public void validate() {
        if (this.targets() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targets in model BulkDeploySolutionParameter"));
        }
        this.targets().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("targets", this.targets, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static BulkDeploySolutionParameter fromJson(JsonReader jsonReader) throws IOException {
        return (BulkDeploySolutionParameter)jsonReader.readObject(reader -> {
            BulkDeploySolutionParameter deserializedBulkDeploySolutionParameter = new BulkDeploySolutionParameter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targets".equals(fieldName)) {
                    List targets;
                    deserializedBulkDeploySolutionParameter.targets = targets = reader.readArray(reader1 -> BulkDeployTargetDetails.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBulkDeploySolutionParameter;
        });
    }
}

