/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.fluent.models.WorkflowInner;
import java.io.IOException;
import java.util.List;

public final class WorkflowListResult
implements JsonSerializable<WorkflowListResult> {
    private List<WorkflowInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(WorkflowListResult.class);

    private WorkflowListResult() {
    }

    public List<WorkflowInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model WorkflowListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static WorkflowListResult fromJson(JsonReader jsonReader) throws IOException {
        return (WorkflowListResult)jsonReader.readObject(reader -> {
            WorkflowListResult deserializedWorkflowListResult = new WorkflowListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedWorkflowListResult.value = value = reader.readArray(reader1 -> WorkflowInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedWorkflowListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkflowListResult;
        });
    }
}

