/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.fluent.models.SolutionVersionInner;
import java.io.IOException;
import java.util.List;

public final class SolutionVersionListResult
implements JsonSerializable<SolutionVersionListResult> {
    private List<SolutionVersionInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(SolutionVersionListResult.class);

    private SolutionVersionListResult() {
    }

    public List<SolutionVersionInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model SolutionVersionListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static SolutionVersionListResult fromJson(JsonReader jsonReader) throws IOException {
        return (SolutionVersionListResult)jsonReader.readObject(reader -> {
            SolutionVersionListResult deserializedSolutionVersionListResult = new SolutionVersionListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedSolutionVersionListResult.value = value = reader.readArray(reader1 -> SolutionVersionInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedSolutionVersionListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSolutionVersionListResult;
        });
    }
}

