/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.fluent.models.SolutionTemplateInner;
import java.io.IOException;
import java.util.List;

public final class SolutionTemplateListResult
implements JsonSerializable<SolutionTemplateListResult> {
    private List<SolutionTemplateInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(SolutionTemplateListResult.class);

    private SolutionTemplateListResult() {
    }

    public List<SolutionTemplateInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model SolutionTemplateListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static SolutionTemplateListResult fromJson(JsonReader jsonReader) throws IOException {
        return (SolutionTemplateListResult)jsonReader.readObject(reader -> {
            SolutionTemplateListResult deserializedSolutionTemplateListResult = new SolutionTemplateListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedSolutionTemplateListResult.value = value = reader.readArray(reader1 -> SolutionTemplateInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedSolutionTemplateListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSolutionTemplateListResult;
        });
    }
}

