/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.fluent.models.ExecutionInner;
import java.io.IOException;
import java.util.List;

public final class ExecutionListResult
implements JsonSerializable<ExecutionListResult> {
    private List<ExecutionInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(ExecutionListResult.class);

    private ExecutionListResult() {
    }

    public List<ExecutionInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model ExecutionListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static ExecutionListResult fromJson(JsonReader jsonReader) throws IOException {
        return (ExecutionListResult)jsonReader.readObject(reader -> {
            ExecutionListResult deserializedExecutionListResult = new ExecutionListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedExecutionListResult.value = value = reader.readArray(reader1 -> ExecutionInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedExecutionListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExecutionListResult;
        });
    }
}

