/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.fluent.models.ConfigTemplateVersionInner;
import java.io.IOException;
import java.util.List;

public final class ConfigTemplateVersionListResult
implements JsonSerializable<ConfigTemplateVersionListResult> {
    private List<ConfigTemplateVersionInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(ConfigTemplateVersionListResult.class);

    private ConfigTemplateVersionListResult() {
    }

    public List<ConfigTemplateVersionInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model ConfigTemplateVersionListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static ConfigTemplateVersionListResult fromJson(JsonReader jsonReader) throws IOException {
        return (ConfigTemplateVersionListResult)jsonReader.readObject(reader -> {
            ConfigTemplateVersionListResult deserializedConfigTemplateVersionListResult = new ConfigTemplateVersionListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedConfigTemplateVersionListResult.value = value = reader.readArray(reader1 -> ConfigTemplateVersionInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedConfigTemplateVersionListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConfigTemplateVersionListResult;
        });
    }
}

