/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.fluent.models.ConfigTemplateInner;
import java.io.IOException;
import java.util.List;

public final class ConfigTemplateListResult
implements JsonSerializable<ConfigTemplateListResult> {
    private List<ConfigTemplateInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(ConfigTemplateListResult.class);

    private ConfigTemplateListResult() {
    }

    public List<ConfigTemplateInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model ConfigTemplateListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static ConfigTemplateListResult fromJson(JsonReader jsonReader) throws IOException {
        return (ConfigTemplateListResult)jsonReader.readObject(reader -> {
            ConfigTemplateListResult deserializedConfigTemplateListResult = new ConfigTemplateListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedConfigTemplateListResult.value = value = reader.readArray(reader1 -> ConfigTemplateInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedConfigTemplateListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConfigTemplateListResult;
        });
    }
}

