/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.management.polling.PollerFactory;
import com.azure.core.management.polling.SyncPollerFactory;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.AsyncPollResponse;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.workloadorchestration.fluent.ConfigTemplateVersionsClient;
import com.azure.resourcemanager.workloadorchestration.fluent.ConfigTemplatesClient;
import com.azure.resourcemanager.workloadorchestration.fluent.ContextsClient;
import com.azure.resourcemanager.workloadorchestration.fluent.DiagnosticsClient;
import com.azure.resourcemanager.workloadorchestration.fluent.DynamicSchemaVersionsClient;
import com.azure.resourcemanager.workloadorchestration.fluent.DynamicSchemasClient;
import com.azure.resourcemanager.workloadorchestration.fluent.ExecutionsClient;
import com.azure.resourcemanager.workloadorchestration.fluent.InstanceHistoriesClient;
import com.azure.resourcemanager.workloadorchestration.fluent.InstancesClient;
import com.azure.resourcemanager.workloadorchestration.fluent.JobsClient;
import com.azure.resourcemanager.workloadorchestration.fluent.SchemaReferencesClient;
import com.azure.resourcemanager.workloadorchestration.fluent.SchemaVersionsClient;
import com.azure.resourcemanager.workloadorchestration.fluent.SchemasClient;
import com.azure.resourcemanager.workloadorchestration.fluent.SiteReferencesClient;
import com.azure.resourcemanager.workloadorchestration.fluent.SolutionTemplateVersionsClient;
import com.azure.resourcemanager.workloadorchestration.fluent.SolutionTemplatesClient;
import com.azure.resourcemanager.workloadorchestration.fluent.SolutionVersionsClient;
import com.azure.resourcemanager.workloadorchestration.fluent.SolutionsClient;
import com.azure.resourcemanager.workloadorchestration.fluent.TargetsClient;
import com.azure.resourcemanager.workloadorchestration.fluent.WorkflowVersionsClient;
import com.azure.resourcemanager.workloadorchestration.fluent.WorkflowsClient;
import com.azure.resourcemanager.workloadorchestration.fluent.WorkloadOrchestrationManagementClient;
import com.azure.resourcemanager.workloadorchestration.implementation.ConfigTemplateVersionsClientImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.ConfigTemplatesClientImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.ContextsClientImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.DiagnosticsClientImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.DynamicSchemaVersionsClientImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.DynamicSchemasClientImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.ExecutionsClientImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.InstanceHistoriesClientImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.InstancesClientImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.JobsClientImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.SchemaReferencesClientImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.SchemaVersionsClientImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.SchemasClientImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.SiteReferencesClientImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.SolutionTemplateVersionsClientImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.SolutionTemplatesClientImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.SolutionVersionsClientImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.SolutionsClientImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.TargetsClientImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.WorkflowVersionsClientImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.WorkflowsClientImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.WorkloadOrchestrationManagementClientBuilder;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=WorkloadOrchestrationManagementClientBuilder.class)
public final class WorkloadOrchestrationManagementClientImpl
implements WorkloadOrchestrationManagementClient {
    private final String endpoint;
    private final String apiVersion;
    private final String subscriptionId;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final DynamicSchemasClient dynamicSchemas;
    private final SchemasClient schemas;
    private final SchemaVersionsClient schemaVersions;
    private final SolutionVersionsClient solutionVersions;
    private final JobsClient jobs;
    private final TargetsClient targets;
    private final DynamicSchemaVersionsClient dynamicSchemaVersions;
    private final SchemaReferencesClient schemaReferences;
    private final SolutionsClient solutions;
    private final SolutionTemplateVersionsClient solutionTemplateVersions;
    private final SolutionTemplatesClient solutionTemplates;
    private final InstancesClient instances;
    private final InstanceHistoriesClient instanceHistories;
    private final ConfigTemplatesClient configTemplates;
    private final ConfigTemplateVersionsClient configTemplateVersions;
    private final WorkflowsClient workflows;
    private final WorkflowVersionsClient workflowVersions;
    private final ExecutionsClient executions;
    private final DiagnosticsClient diagnostics;
    private final ContextsClient contexts;
    private final SiteReferencesClient siteReferences;
    private static final ClientLogger LOGGER = new ClientLogger(WorkloadOrchestrationManagementClientImpl.class);

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public DynamicSchemasClient getDynamicSchemas() {
        return this.dynamicSchemas;
    }

    @Override
    public SchemasClient getSchemas() {
        return this.schemas;
    }

    @Override
    public SchemaVersionsClient getSchemaVersions() {
        return this.schemaVersions;
    }

    @Override
    public SolutionVersionsClient getSolutionVersions() {
        return this.solutionVersions;
    }

    @Override
    public JobsClient getJobs() {
        return this.jobs;
    }

    @Override
    public TargetsClient getTargets() {
        return this.targets;
    }

    @Override
    public DynamicSchemaVersionsClient getDynamicSchemaVersions() {
        return this.dynamicSchemaVersions;
    }

    @Override
    public SchemaReferencesClient getSchemaReferences() {
        return this.schemaReferences;
    }

    @Override
    public SolutionsClient getSolutions() {
        return this.solutions;
    }

    @Override
    public SolutionTemplateVersionsClient getSolutionTemplateVersions() {
        return this.solutionTemplateVersions;
    }

    @Override
    public SolutionTemplatesClient getSolutionTemplates() {
        return this.solutionTemplates;
    }

    @Override
    public InstancesClient getInstances() {
        return this.instances;
    }

    @Override
    public InstanceHistoriesClient getInstanceHistories() {
        return this.instanceHistories;
    }

    @Override
    public ConfigTemplatesClient getConfigTemplates() {
        return this.configTemplates;
    }

    @Override
    public ConfigTemplateVersionsClient getConfigTemplateVersions() {
        return this.configTemplateVersions;
    }

    @Override
    public WorkflowsClient getWorkflows() {
        return this.workflows;
    }

    @Override
    public WorkflowVersionsClient getWorkflowVersions() {
        return this.workflowVersions;
    }

    @Override
    public ExecutionsClient getExecutions() {
        return this.executions;
    }

    @Override
    public DiagnosticsClient getDiagnostics() {
        return this.diagnostics;
    }

    @Override
    public ContextsClient getContexts() {
        return this.contexts;
    }

    @Override
    public SiteReferencesClient getSiteReferences() {
        return this.siteReferences;
    }

    WorkloadOrchestrationManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String endpoint, String subscriptionId) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.endpoint = endpoint;
        this.subscriptionId = subscriptionId;
        this.apiVersion = "2025-06-01";
        this.dynamicSchemas = new DynamicSchemasClientImpl(this);
        this.schemas = new SchemasClientImpl(this);
        this.schemaVersions = new SchemaVersionsClientImpl(this);
        this.solutionVersions = new SolutionVersionsClientImpl(this);
        this.jobs = new JobsClientImpl(this);
        this.targets = new TargetsClientImpl(this);
        this.dynamicSchemaVersions = new DynamicSchemaVersionsClientImpl(this);
        this.schemaReferences = new SchemaReferencesClientImpl(this);
        this.solutions = new SolutionsClientImpl(this);
        this.solutionTemplateVersions = new SolutionTemplateVersionsClientImpl(this);
        this.solutionTemplates = new SolutionTemplatesClientImpl(this);
        this.instances = new InstancesClientImpl(this);
        this.instanceHistories = new InstanceHistoriesClientImpl(this);
        this.configTemplates = new ConfigTemplatesClientImpl(this);
        this.configTemplateVersions = new ConfigTemplateVersionsClientImpl(this);
        this.workflows = new WorkflowsClientImpl(this);
        this.workflowVersions = new WorkflowVersionsClientImpl(this);
        this.executions = new ExecutionsClientImpl(this);
        this.diagnostics = new DiagnosticsClientImpl(this);
        this.contexts = new ContextsClientImpl(this);
        this.siteReferences = new SiteReferencesClientImpl(this);
    }

    public Context getContext() {
        return Context.NONE;
    }

    public Context mergeContext(Context context) {
        return CoreUtils.mergeContexts((Context)this.getContext(), (Context)context);
    }

    public <T, U> PollerFlux<PollResult<T>, U> getLroResult(Mono<Response<Flux<ByteBuffer>>> activationResponse, HttpPipeline httpPipeline, Type pollResultType, Type finalResultType, Context context) {
        return PollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, activationResponse, (Context)context);
    }

    public <T, U> SyncPoller<PollResult<T>, U> getLroResult(Response<BinaryData> activationResponse, Type pollResultType, Type finalResultType, Context context) {
        return SyncPollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)this.httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, () -> activationResponse, (Context)context);
    }

    public <T, U> Mono<U> getLroFinalResultOrError(AsyncPollResponse<PollResult<T>, U> response) {
        if (response.getStatus() != LongRunningOperationStatus.SUCCESSFULLY_COMPLETED) {
            String errorMessage;
            ManagementError managementError = null;
            HttpResponseImpl errorResponse = null;
            PollResult.Error lroError = ((PollResult)response.getValue()).getError();
            if (lroError != null) {
                errorResponse = new HttpResponseImpl(lroError.getResponseStatusCode(), lroError.getResponseHeaders(), lroError.getResponseBody());
                errorMessage = ((PollResult)response.getValue()).getError().getMessage();
                String errorBody = ((PollResult)response.getValue()).getError().getResponseBody();
                if (errorBody != null) {
                    try {
                        managementError = (ManagementError)this.getSerializerAdapter().deserialize(errorBody, ManagementError.class, SerializerEncoding.JSON);
                        if (managementError.getCode() == null || managementError.getMessage() == null) {
                            managementError = null;
                        }
                    }
                    catch (IOException | RuntimeException ioe) {
                        LOGGER.logThrowableAsWarning((Throwable)ioe);
                    }
                }
            } else {
                errorMessage = "Long running operation failed.";
            }
            if (managementError == null) {
                managementError = new ManagementError(response.getStatus().toString(), errorMessage);
            }
            return Mono.error((Throwable)new ManagementException(errorMessage, (HttpResponse)errorResponse, managementError));
        }
        return response.getFinalResult();
    }

    private static final class HttpResponseImpl
    extends HttpResponse {
        private final int statusCode;
        private final byte[] responseBody;
        private final HttpHeaders httpHeaders;

        HttpResponseImpl(int statusCode, HttpHeaders httpHeaders, String responseBody) {
            super(null);
            this.statusCode = statusCode;
            this.httpHeaders = httpHeaders;
            this.responseBody = responseBody == null ? null : responseBody.getBytes(StandardCharsets.UTF_8);
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getHeaderValue(String s) {
            return this.httpHeaders.getValue(HttpHeaderName.fromString((String)s));
        }

        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.just((Object)ByteBuffer.wrap(this.responseBody));
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.just((Object)this.responseBody);
        }

        public Mono<String> getBodyAsString() {
            return Mono.just((Object)new String(this.responseBody, StandardCharsets.UTF_8));
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.just((Object)new String(this.responseBody, charset));
        }
    }
}

