/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.workloadorchestration.WorkloadOrchestrationManager;
import com.azure.resourcemanager.workloadorchestration.fluent.models.WorkflowVersionInner;
import com.azure.resourcemanager.workloadorchestration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadorchestration.models.ExtendedLocation;
import com.azure.resourcemanager.workloadorchestration.models.WorkflowVersion;
import com.azure.resourcemanager.workloadorchestration.models.WorkflowVersionProperties;

public final class WorkflowVersionImpl
implements WorkflowVersion,
WorkflowVersion.Definition,
WorkflowVersion.Update {
    private WorkflowVersionInner innerObject;
    private final WorkloadOrchestrationManager serviceManager;
    private String resourceGroupName;
    private String contextName;
    private String workflowName;
    private String versionName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public WorkflowVersionProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public ExtendedLocation extendedLocation() {
        return this.innerModel().extendedLocation();
    }

    @Override
    public String eTag() {
        return this.innerModel().eTag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public WorkflowVersionInner innerModel() {
        return this.innerObject;
    }

    private WorkloadOrchestrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public WorkflowVersionImpl withExistingWorkflow(String resourceGroupName, String contextName, String workflowName) {
        this.resourceGroupName = resourceGroupName;
        this.contextName = contextName;
        this.workflowName = workflowName;
        return this;
    }

    @Override
    public WorkflowVersion create() {
        this.innerObject = this.serviceManager.serviceClient().getWorkflowVersions().createOrUpdate(this.resourceGroupName, this.contextName, this.workflowName, this.versionName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public WorkflowVersion create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getWorkflowVersions().createOrUpdate(this.resourceGroupName, this.contextName, this.workflowName, this.versionName, this.innerModel(), context);
        return this;
    }

    WorkflowVersionImpl(String name, WorkloadOrchestrationManager serviceManager) {
        this.innerObject = new WorkflowVersionInner();
        this.serviceManager = serviceManager;
        this.versionName = name;
    }

    @Override
    public WorkflowVersionImpl update() {
        return this;
    }

    @Override
    public WorkflowVersion apply() {
        this.innerObject = this.serviceManager.serviceClient().getWorkflowVersions().update(this.resourceGroupName, this.contextName, this.workflowName, this.versionName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public WorkflowVersion apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getWorkflowVersions().update(this.resourceGroupName, this.contextName, this.workflowName, this.versionName, this.innerModel(), context);
        return this;
    }

    WorkflowVersionImpl(WorkflowVersionInner innerObject, WorkloadOrchestrationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.contextName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "contexts");
        this.workflowName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "workflows");
        this.versionName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "versions");
    }

    @Override
    public WorkflowVersion refresh() {
        this.innerObject = (WorkflowVersionInner)((Object)this.serviceManager.serviceClient().getWorkflowVersions().getWithResponse(this.resourceGroupName, this.contextName, this.workflowName, this.versionName, Context.NONE).getValue());
        return this;
    }

    @Override
    public WorkflowVersion refresh(Context context) {
        this.innerObject = (WorkflowVersionInner)((Object)this.serviceManager.serviceClient().getWorkflowVersions().getWithResponse(this.resourceGroupName, this.contextName, this.workflowName, this.versionName, context).getValue());
        return this;
    }

    @Override
    public WorkflowVersionImpl withProperties(WorkflowVersionProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public WorkflowVersionImpl withExtendedLocation(ExtendedLocation extendedLocation) {
        this.innerModel().withExtendedLocation(extendedLocation);
        return this;
    }
}

