/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.workloadorchestration.WorkloadOrchestrationManager;
import com.azure.resourcemanager.workloadorchestration.fluent.models.WorkflowInner;
import com.azure.resourcemanager.workloadorchestration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadorchestration.models.ExtendedLocation;
import com.azure.resourcemanager.workloadorchestration.models.Workflow;
import com.azure.resourcemanager.workloadorchestration.models.WorkflowProperties;

public final class WorkflowImpl
implements Workflow,
Workflow.Definition,
Workflow.Update {
    private WorkflowInner innerObject;
    private final WorkloadOrchestrationManager serviceManager;
    private String resourceGroupName;
    private String contextName;
    private String workflowName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public WorkflowProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public ExtendedLocation extendedLocation() {
        return this.innerModel().extendedLocation();
    }

    @Override
    public String eTag() {
        return this.innerModel().eTag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public WorkflowInner innerModel() {
        return this.innerObject;
    }

    private WorkloadOrchestrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public WorkflowImpl withExistingContext(String resourceGroupName, String contextName) {
        this.resourceGroupName = resourceGroupName;
        this.contextName = contextName;
        return this;
    }

    @Override
    public Workflow create() {
        this.innerObject = this.serviceManager.serviceClient().getWorkflows().createOrUpdate(this.resourceGroupName, this.contextName, this.workflowName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Workflow create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getWorkflows().createOrUpdate(this.resourceGroupName, this.contextName, this.workflowName, this.innerModel(), context);
        return this;
    }

    WorkflowImpl(String name, WorkloadOrchestrationManager serviceManager) {
        this.innerObject = new WorkflowInner();
        this.serviceManager = serviceManager;
        this.workflowName = name;
    }

    @Override
    public WorkflowImpl update() {
        return this;
    }

    @Override
    public Workflow apply() {
        this.innerObject = this.serviceManager.serviceClient().getWorkflows().update(this.resourceGroupName, this.contextName, this.workflowName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Workflow apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getWorkflows().update(this.resourceGroupName, this.contextName, this.workflowName, this.innerModel(), context);
        return this;
    }

    WorkflowImpl(WorkflowInner innerObject, WorkloadOrchestrationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.contextName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "contexts");
        this.workflowName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "workflows");
    }

    @Override
    public Workflow refresh() {
        this.innerObject = (WorkflowInner)((Object)this.serviceManager.serviceClient().getWorkflows().getWithResponse(this.resourceGroupName, this.contextName, this.workflowName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Workflow refresh(Context context) {
        this.innerObject = (WorkflowInner)((Object)this.serviceManager.serviceClient().getWorkflows().getWithResponse(this.resourceGroupName, this.contextName, this.workflowName, context).getValue());
        return this;
    }

    @Override
    public WorkflowImpl withProperties(WorkflowProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public WorkflowImpl withExtendedLocation(ExtendedLocation extendedLocation) {
        this.innerModel().withExtendedLocation(extendedLocation);
        return this;
    }
}

