/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.workloadorchestration.WorkloadOrchestrationManager;
import com.azure.resourcemanager.workloadorchestration.fluent.SolutionsClient;
import com.azure.resourcemanager.workloadorchestration.fluent.models.SolutionInner;
import com.azure.resourcemanager.workloadorchestration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadorchestration.implementation.SolutionImpl;
import com.azure.resourcemanager.workloadorchestration.models.Solution;
import com.azure.resourcemanager.workloadorchestration.models.Solutions;

public final class SolutionsImpl
implements Solutions {
    private static final ClientLogger LOGGER = new ClientLogger(SolutionsImpl.class);
    private final SolutionsClient innerClient;
    private final WorkloadOrchestrationManager serviceManager;

    public SolutionsImpl(SolutionsClient innerClient, WorkloadOrchestrationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Solution> getWithResponse(String resourceGroupName, String targetName, String solutionName, Context context) {
        Response<SolutionInner> inner = this.serviceClient().getWithResponse(resourceGroupName, targetName, solutionName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SolutionImpl((SolutionInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Solution get(String resourceGroupName, String targetName, String solutionName) {
        SolutionInner inner = this.serviceClient().get(resourceGroupName, targetName, solutionName);
        if (inner != null) {
            return new SolutionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String targetName, String solutionName) {
        this.serviceClient().delete(resourceGroupName, targetName, solutionName);
    }

    @Override
    public void delete(String resourceGroupName, String targetName, String solutionName, Context context) {
        this.serviceClient().delete(resourceGroupName, targetName, solutionName, context);
    }

    @Override
    public PagedIterable<Solution> listByTarget(String resourceGroupName, String targetName) {
        PagedIterable<SolutionInner> inner = this.serviceClient().listByTarget(resourceGroupName, targetName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SolutionImpl((SolutionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Solution> listByTarget(String resourceGroupName, String targetName, Context context) {
        PagedIterable<SolutionInner> inner = this.serviceClient().listByTarget(resourceGroupName, targetName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SolutionImpl((SolutionInner)((Object)inner1), this.manager()));
    }

    @Override
    public Solution getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String targetName = ResourceManagerUtils.getValueFromIdByName(id, "targets");
        if (targetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'targets'.", id)));
        }
        String solutionName = ResourceManagerUtils.getValueFromIdByName(id, "solutions");
        if (solutionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'solutions'.", id)));
        }
        return (Solution)this.getWithResponse(resourceGroupName, targetName, solutionName, Context.NONE).getValue();
    }

    @Override
    public Response<Solution> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String targetName = ResourceManagerUtils.getValueFromIdByName(id, "targets");
        if (targetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'targets'.", id)));
        }
        String solutionName = ResourceManagerUtils.getValueFromIdByName(id, "solutions");
        if (solutionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'solutions'.", id)));
        }
        return this.getWithResponse(resourceGroupName, targetName, solutionName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String targetName = ResourceManagerUtils.getValueFromIdByName(id, "targets");
        if (targetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'targets'.", id)));
        }
        String solutionName = ResourceManagerUtils.getValueFromIdByName(id, "solutions");
        if (solutionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'solutions'.", id)));
        }
        this.delete(resourceGroupName, targetName, solutionName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String targetName = ResourceManagerUtils.getValueFromIdByName(id, "targets");
        if (targetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'targets'.", id)));
        }
        String solutionName = ResourceManagerUtils.getValueFromIdByName(id, "solutions");
        if (solutionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'solutions'.", id)));
        }
        this.delete(resourceGroupName, targetName, solutionName, context);
    }

    private SolutionsClient serviceClient() {
        return this.innerClient;
    }

    private WorkloadOrchestrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public SolutionImpl define(String name) {
        return new SolutionImpl(name, this.manager());
    }
}

