/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.workloadorchestration.WorkloadOrchestrationManager;
import com.azure.resourcemanager.workloadorchestration.fluent.SolutionTemplatesClient;
import com.azure.resourcemanager.workloadorchestration.fluent.models.SolutionTemplateInner;
import com.azure.resourcemanager.workloadorchestration.fluent.models.SolutionTemplateVersionInner;
import com.azure.resourcemanager.workloadorchestration.fluent.models.SolutionTemplateVersionWithUpdateTypeInner;
import com.azure.resourcemanager.workloadorchestration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadorchestration.implementation.SolutionTemplateImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.SolutionTemplateVersionImpl;
import com.azure.resourcemanager.workloadorchestration.models.SolutionTemplate;
import com.azure.resourcemanager.workloadorchestration.models.SolutionTemplateVersion;
import com.azure.resourcemanager.workloadorchestration.models.SolutionTemplates;
import com.azure.resourcemanager.workloadorchestration.models.VersionParameter;

public final class SolutionTemplatesImpl
implements SolutionTemplates {
    private static final ClientLogger LOGGER = new ClientLogger(SolutionTemplatesImpl.class);
    private final SolutionTemplatesClient innerClient;
    private final WorkloadOrchestrationManager serviceManager;

    public SolutionTemplatesImpl(SolutionTemplatesClient innerClient, WorkloadOrchestrationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<SolutionTemplate> getByResourceGroupWithResponse(String resourceGroupName, String solutionTemplateName, Context context) {
        Response<SolutionTemplateInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, solutionTemplateName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SolutionTemplateImpl((SolutionTemplateInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SolutionTemplate getByResourceGroup(String resourceGroupName, String solutionTemplateName) {
        SolutionTemplateInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, solutionTemplateName);
        if (inner != null) {
            return new SolutionTemplateImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public SolutionTemplateVersion createVersion(String resourceGroupName, String solutionTemplateName, SolutionTemplateVersionWithUpdateTypeInner body) {
        SolutionTemplateVersionInner inner = this.serviceClient().createVersion(resourceGroupName, solutionTemplateName, body);
        if (inner != null) {
            return new SolutionTemplateVersionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public SolutionTemplateVersion createVersion(String resourceGroupName, String solutionTemplateName, SolutionTemplateVersionWithUpdateTypeInner body, Context context) {
        SolutionTemplateVersionInner inner = this.serviceClient().createVersion(resourceGroupName, solutionTemplateName, body, context);
        if (inner != null) {
            return new SolutionTemplateVersionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void removeVersion(String resourceGroupName, String solutionTemplateName, VersionParameter body) {
        this.serviceClient().removeVersion(resourceGroupName, solutionTemplateName, body);
    }

    @Override
    public void removeVersion(String resourceGroupName, String solutionTemplateName, VersionParameter body, Context context) {
        this.serviceClient().removeVersion(resourceGroupName, solutionTemplateName, body, context);
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String solutionTemplateName) {
        this.serviceClient().delete(resourceGroupName, solutionTemplateName);
    }

    @Override
    public void delete(String resourceGroupName, String solutionTemplateName, Context context) {
        this.serviceClient().delete(resourceGroupName, solutionTemplateName, context);
    }

    @Override
    public PagedIterable<SolutionTemplate> listByResourceGroup(String resourceGroupName) {
        PagedIterable<SolutionTemplateInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SolutionTemplateImpl((SolutionTemplateInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SolutionTemplate> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<SolutionTemplateInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SolutionTemplateImpl((SolutionTemplateInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SolutionTemplate> list() {
        PagedIterable<SolutionTemplateInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SolutionTemplateImpl((SolutionTemplateInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SolutionTemplate> list(Context context) {
        PagedIterable<SolutionTemplateInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SolutionTemplateImpl((SolutionTemplateInner)((Object)inner1), this.manager()));
    }

    @Override
    public SolutionTemplate getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String solutionTemplateName = ResourceManagerUtils.getValueFromIdByName(id, "solutionTemplates");
        if (solutionTemplateName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'solutionTemplates'.", id)));
        }
        return (SolutionTemplate)this.getByResourceGroupWithResponse(resourceGroupName, solutionTemplateName, Context.NONE).getValue();
    }

    @Override
    public Response<SolutionTemplate> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String solutionTemplateName = ResourceManagerUtils.getValueFromIdByName(id, "solutionTemplates");
        if (solutionTemplateName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'solutionTemplates'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, solutionTemplateName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String solutionTemplateName = ResourceManagerUtils.getValueFromIdByName(id, "solutionTemplates");
        if (solutionTemplateName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'solutionTemplates'.", id)));
        }
        this.delete(resourceGroupName, solutionTemplateName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String solutionTemplateName = ResourceManagerUtils.getValueFromIdByName(id, "solutionTemplates");
        if (solutionTemplateName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'solutionTemplates'.", id)));
        }
        this.delete(resourceGroupName, solutionTemplateName, context);
    }

    private SolutionTemplatesClient serviceClient() {
        return this.innerClient;
    }

    private WorkloadOrchestrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public SolutionTemplateImpl define(String name) {
        return new SolutionTemplateImpl(name, this.manager());
    }
}

