/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.workloadorchestration.WorkloadOrchestrationManager;
import com.azure.resourcemanager.workloadorchestration.fluent.SolutionTemplateVersionsClient;
import com.azure.resourcemanager.workloadorchestration.fluent.models.SolutionTemplateVersionInner;
import com.azure.resourcemanager.workloadorchestration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadorchestration.implementation.SolutionTemplateVersionImpl;
import com.azure.resourcemanager.workloadorchestration.models.BulkDeploySolutionParameter;
import com.azure.resourcemanager.workloadorchestration.models.BulkPublishSolutionParameter;
import com.azure.resourcemanager.workloadorchestration.models.SolutionTemplateVersion;
import com.azure.resourcemanager.workloadorchestration.models.SolutionTemplateVersions;

public final class SolutionTemplateVersionsImpl
implements SolutionTemplateVersions {
    private static final ClientLogger LOGGER = new ClientLogger(SolutionTemplateVersionsImpl.class);
    private final SolutionTemplateVersionsClient innerClient;
    private final WorkloadOrchestrationManager serviceManager;

    public SolutionTemplateVersionsImpl(SolutionTemplateVersionsClient innerClient, WorkloadOrchestrationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<SolutionTemplateVersion> getWithResponse(String resourceGroupName, String solutionTemplateName, String solutionTemplateVersionName, Context context) {
        Response<SolutionTemplateVersionInner> inner = this.serviceClient().getWithResponse(resourceGroupName, solutionTemplateName, solutionTemplateVersionName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SolutionTemplateVersionImpl((SolutionTemplateVersionInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SolutionTemplateVersion get(String resourceGroupName, String solutionTemplateName, String solutionTemplateVersionName) {
        SolutionTemplateVersionInner inner = this.serviceClient().get(resourceGroupName, solutionTemplateName, solutionTemplateVersionName);
        if (inner != null) {
            return new SolutionTemplateVersionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<SolutionTemplateVersion> listBySolutionTemplate(String resourceGroupName, String solutionTemplateName) {
        PagedIterable<SolutionTemplateVersionInner> inner = this.serviceClient().listBySolutionTemplate(resourceGroupName, solutionTemplateName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SolutionTemplateVersionImpl((SolutionTemplateVersionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SolutionTemplateVersion> listBySolutionTemplate(String resourceGroupName, String solutionTemplateName, Context context) {
        PagedIterable<SolutionTemplateVersionInner> inner = this.serviceClient().listBySolutionTemplate(resourceGroupName, solutionTemplateName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SolutionTemplateVersionImpl((SolutionTemplateVersionInner)((Object)inner1), this.manager()));
    }

    @Override
    public void bulkDeploySolution(String resourceGroupName, String solutionTemplateName, String solutionTemplateVersionName, BulkDeploySolutionParameter body) {
        this.serviceClient().bulkDeploySolution(resourceGroupName, solutionTemplateName, solutionTemplateVersionName, body);
    }

    @Override
    public void bulkDeploySolution(String resourceGroupName, String solutionTemplateName, String solutionTemplateVersionName, BulkDeploySolutionParameter body, Context context) {
        this.serviceClient().bulkDeploySolution(resourceGroupName, solutionTemplateName, solutionTemplateVersionName, body, context);
    }

    @Override
    public void bulkPublishSolution(String resourceGroupName, String solutionTemplateName, String solutionTemplateVersionName, BulkPublishSolutionParameter body) {
        this.serviceClient().bulkPublishSolution(resourceGroupName, solutionTemplateName, solutionTemplateVersionName, body);
    }

    @Override
    public void bulkPublishSolution(String resourceGroupName, String solutionTemplateName, String solutionTemplateVersionName, BulkPublishSolutionParameter body, Context context) {
        this.serviceClient().bulkPublishSolution(resourceGroupName, solutionTemplateName, solutionTemplateVersionName, body, context);
    }

    private SolutionTemplateVersionsClient serviceClient() {
        return this.innerClient;
    }

    private WorkloadOrchestrationManager manager() {
        return this.serviceManager;
    }
}

