/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.workloadorchestration.WorkloadOrchestrationManager;
import com.azure.resourcemanager.workloadorchestration.fluent.models.SolutionTemplateInner;
import com.azure.resourcemanager.workloadorchestration.fluent.models.SolutionTemplateVersionWithUpdateTypeInner;
import com.azure.resourcemanager.workloadorchestration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadorchestration.models.SolutionTemplate;
import com.azure.resourcemanager.workloadorchestration.models.SolutionTemplateProperties;
import com.azure.resourcemanager.workloadorchestration.models.SolutionTemplateVersion;
import com.azure.resourcemanager.workloadorchestration.models.VersionParameter;
import java.util.Collections;
import java.util.Map;

public final class SolutionTemplateImpl
implements SolutionTemplate,
SolutionTemplate.Definition,
SolutionTemplate.Update {
    private SolutionTemplateInner innerObject;
    private final WorkloadOrchestrationManager serviceManager;
    private String resourceGroupName;
    private String solutionTemplateName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public SolutionTemplateProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public String eTag() {
        return this.innerModel().eTag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public SolutionTemplateInner innerModel() {
        return this.innerObject;
    }

    private WorkloadOrchestrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public SolutionTemplateImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public SolutionTemplate create() {
        this.innerObject = this.serviceManager.serviceClient().getSolutionTemplates().createOrUpdate(this.resourceGroupName, this.solutionTemplateName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public SolutionTemplate create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getSolutionTemplates().createOrUpdate(this.resourceGroupName, this.solutionTemplateName, this.innerModel(), context);
        return this;
    }

    SolutionTemplateImpl(String name, WorkloadOrchestrationManager serviceManager) {
        this.innerObject = new SolutionTemplateInner();
        this.serviceManager = serviceManager;
        this.solutionTemplateName = name;
    }

    @Override
    public SolutionTemplateImpl update() {
        return this;
    }

    @Override
    public SolutionTemplate apply() {
        this.innerObject = (SolutionTemplateInner)((Object)this.serviceManager.serviceClient().getSolutionTemplates().updateWithResponse(this.resourceGroupName, this.solutionTemplateName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public SolutionTemplate apply(Context context) {
        this.innerObject = (SolutionTemplateInner)((Object)this.serviceManager.serviceClient().getSolutionTemplates().updateWithResponse(this.resourceGroupName, this.solutionTemplateName, this.innerModel(), context).getValue());
        return this;
    }

    SolutionTemplateImpl(SolutionTemplateInner innerObject, WorkloadOrchestrationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.solutionTemplateName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "solutionTemplates");
    }

    @Override
    public SolutionTemplate refresh() {
        this.innerObject = (SolutionTemplateInner)((Object)this.serviceManager.serviceClient().getSolutionTemplates().getByResourceGroupWithResponse(this.resourceGroupName, this.solutionTemplateName, Context.NONE).getValue());
        return this;
    }

    @Override
    public SolutionTemplate refresh(Context context) {
        this.innerObject = (SolutionTemplateInner)((Object)this.serviceManager.serviceClient().getSolutionTemplates().getByResourceGroupWithResponse(this.resourceGroupName, this.solutionTemplateName, context).getValue());
        return this;
    }

    @Override
    public SolutionTemplateVersion createVersion(SolutionTemplateVersionWithUpdateTypeInner body) {
        return this.serviceManager.solutionTemplates().createVersion(this.resourceGroupName, this.solutionTemplateName, body);
    }

    @Override
    public SolutionTemplateVersion createVersion(SolutionTemplateVersionWithUpdateTypeInner body, Context context) {
        return this.serviceManager.solutionTemplates().createVersion(this.resourceGroupName, this.solutionTemplateName, body, context);
    }

    @Override
    public void removeVersion(VersionParameter body) {
        this.serviceManager.solutionTemplates().removeVersion(this.resourceGroupName, this.solutionTemplateName, body);
    }

    @Override
    public void removeVersion(VersionParameter body, Context context) {
        this.serviceManager.solutionTemplates().removeVersion(this.resourceGroupName, this.solutionTemplateName, body, context);
    }

    @Override
    public SolutionTemplateImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public SolutionTemplateImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public SolutionTemplateImpl withTags(Map<String, String> tags) {
        this.innerModel().withTags((Map)tags);
        return this;
    }

    @Override
    public SolutionTemplateImpl withProperties(SolutionTemplateProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

