/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.workloadorchestration.WorkloadOrchestrationManager;
import com.azure.resourcemanager.workloadorchestration.fluent.SchemasClient;
import com.azure.resourcemanager.workloadorchestration.fluent.models.RemoveVersionResponseInner;
import com.azure.resourcemanager.workloadorchestration.fluent.models.SchemaInner;
import com.azure.resourcemanager.workloadorchestration.fluent.models.SchemaVersionInner;
import com.azure.resourcemanager.workloadorchestration.fluent.models.SchemaVersionWithUpdateTypeInner;
import com.azure.resourcemanager.workloadorchestration.implementation.RemoveVersionResponseImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadorchestration.implementation.SchemaImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.SchemaVersionImpl;
import com.azure.resourcemanager.workloadorchestration.models.RemoveVersionResponse;
import com.azure.resourcemanager.workloadorchestration.models.Schema;
import com.azure.resourcemanager.workloadorchestration.models.SchemaVersion;
import com.azure.resourcemanager.workloadorchestration.models.Schemas;
import com.azure.resourcemanager.workloadorchestration.models.VersionParameter;

public final class SchemasImpl
implements Schemas {
    private static final ClientLogger LOGGER = new ClientLogger(SchemasImpl.class);
    private final SchemasClient innerClient;
    private final WorkloadOrchestrationManager serviceManager;

    public SchemasImpl(SchemasClient innerClient, WorkloadOrchestrationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Schema> getByResourceGroupWithResponse(String resourceGroupName, String schemaName, Context context) {
        Response<SchemaInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, schemaName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SchemaImpl((SchemaInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Schema getByResourceGroup(String resourceGroupName, String schemaName) {
        SchemaInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, schemaName);
        if (inner != null) {
            return new SchemaImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String schemaName) {
        this.serviceClient().delete(resourceGroupName, schemaName);
    }

    @Override
    public void delete(String resourceGroupName, String schemaName, Context context) {
        this.serviceClient().delete(resourceGroupName, schemaName, context);
    }

    @Override
    public SchemaVersion createVersion(String resourceGroupName, String schemaName, SchemaVersionWithUpdateTypeInner body) {
        SchemaVersionInner inner = this.serviceClient().createVersion(resourceGroupName, schemaName, body);
        if (inner != null) {
            return new SchemaVersionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public SchemaVersion createVersion(String resourceGroupName, String schemaName, SchemaVersionWithUpdateTypeInner body, Context context) {
        SchemaVersionInner inner = this.serviceClient().createVersion(resourceGroupName, schemaName, body, context);
        if (inner != null) {
            return new SchemaVersionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<RemoveVersionResponse> removeVersionWithResponse(String resourceGroupName, String schemaName, VersionParameter body, Context context) {
        Response<RemoveVersionResponseInner> inner = this.serviceClient().removeVersionWithResponse(resourceGroupName, schemaName, body, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RemoveVersionResponseImpl((RemoveVersionResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public RemoveVersionResponse removeVersion(String resourceGroupName, String schemaName, VersionParameter body) {
        RemoveVersionResponseInner inner = this.serviceClient().removeVersion(resourceGroupName, schemaName, body);
        if (inner != null) {
            return new RemoveVersionResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<Schema> listByResourceGroup(String resourceGroupName) {
        PagedIterable<SchemaInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SchemaImpl((SchemaInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Schema> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<SchemaInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SchemaImpl((SchemaInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Schema> list() {
        PagedIterable<SchemaInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SchemaImpl((SchemaInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Schema> list(Context context) {
        PagedIterable<SchemaInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SchemaImpl((SchemaInner)((Object)inner1), this.manager()));
    }

    @Override
    public Schema getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String schemaName = ResourceManagerUtils.getValueFromIdByName(id, "schemas");
        if (schemaName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'schemas'.", id)));
        }
        return (Schema)this.getByResourceGroupWithResponse(resourceGroupName, schemaName, Context.NONE).getValue();
    }

    @Override
    public Response<Schema> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String schemaName = ResourceManagerUtils.getValueFromIdByName(id, "schemas");
        if (schemaName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'schemas'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, schemaName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String schemaName = ResourceManagerUtils.getValueFromIdByName(id, "schemas");
        if (schemaName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'schemas'.", id)));
        }
        this.delete(resourceGroupName, schemaName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String schemaName = ResourceManagerUtils.getValueFromIdByName(id, "schemas");
        if (schemaName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'schemas'.", id)));
        }
        this.delete(resourceGroupName, schemaName, context);
    }

    private SchemasClient serviceClient() {
        return this.innerClient;
    }

    private WorkloadOrchestrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public SchemaImpl define(String name) {
        return new SchemaImpl(name, this.manager());
    }
}

