/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.workloadorchestration.WorkloadOrchestrationManager;
import com.azure.resourcemanager.workloadorchestration.fluent.models.SchemaVersionInner;
import com.azure.resourcemanager.workloadorchestration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadorchestration.models.SchemaVersion;
import com.azure.resourcemanager.workloadorchestration.models.SchemaVersionProperties;

public final class SchemaVersionImpl
implements SchemaVersion,
SchemaVersion.Definition,
SchemaVersion.Update {
    private SchemaVersionInner innerObject;
    private final WorkloadOrchestrationManager serviceManager;
    private String resourceGroupName;
    private String schemaName;
    private String schemaVersionName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SchemaVersionProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public String eTag() {
        return this.innerModel().eTag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public SchemaVersionInner innerModel() {
        return this.innerObject;
    }

    private WorkloadOrchestrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public SchemaVersionImpl withExistingSchema(String resourceGroupName, String schemaName) {
        this.resourceGroupName = resourceGroupName;
        this.schemaName = schemaName;
        return this;
    }

    @Override
    public SchemaVersion create() {
        this.innerObject = this.serviceManager.serviceClient().getSchemaVersions().createOrUpdate(this.resourceGroupName, this.schemaName, this.schemaVersionName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public SchemaVersion create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getSchemaVersions().createOrUpdate(this.resourceGroupName, this.schemaName, this.schemaVersionName, this.innerModel(), context);
        return this;
    }

    SchemaVersionImpl(String name, WorkloadOrchestrationManager serviceManager) {
        this.innerObject = new SchemaVersionInner();
        this.serviceManager = serviceManager;
        this.schemaVersionName = name;
    }

    @Override
    public SchemaVersionImpl update() {
        return this;
    }

    @Override
    public SchemaVersion apply() {
        this.innerObject = (SchemaVersionInner)((Object)this.serviceManager.serviceClient().getSchemaVersions().updateWithResponse(this.resourceGroupName, this.schemaName, this.schemaVersionName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public SchemaVersion apply(Context context) {
        this.innerObject = (SchemaVersionInner)((Object)this.serviceManager.serviceClient().getSchemaVersions().updateWithResponse(this.resourceGroupName, this.schemaName, this.schemaVersionName, this.innerModel(), context).getValue());
        return this;
    }

    SchemaVersionImpl(SchemaVersionInner innerObject, WorkloadOrchestrationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.schemaName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "schemas");
        this.schemaVersionName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "versions");
    }

    @Override
    public SchemaVersion refresh() {
        this.innerObject = (SchemaVersionInner)((Object)this.serviceManager.serviceClient().getSchemaVersions().getWithResponse(this.resourceGroupName, this.schemaName, this.schemaVersionName, Context.NONE).getValue());
        return this;
    }

    @Override
    public SchemaVersion refresh(Context context) {
        this.innerObject = (SchemaVersionInner)((Object)this.serviceManager.serviceClient().getSchemaVersions().getWithResponse(this.resourceGroupName, this.schemaName, this.schemaVersionName, context).getValue());
        return this;
    }

    @Override
    public SchemaVersionImpl withProperties(SchemaVersionProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

