/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.workloadorchestration.WorkloadOrchestrationManager;
import com.azure.resourcemanager.workloadorchestration.fluent.InstancesClient;
import com.azure.resourcemanager.workloadorchestration.fluent.models.InstanceInner;
import com.azure.resourcemanager.workloadorchestration.implementation.InstanceImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadorchestration.models.Instance;
import com.azure.resourcemanager.workloadorchestration.models.Instances;

public final class InstancesImpl
implements Instances {
    private static final ClientLogger LOGGER = new ClientLogger(InstancesImpl.class);
    private final InstancesClient innerClient;
    private final WorkloadOrchestrationManager serviceManager;

    public InstancesImpl(InstancesClient innerClient, WorkloadOrchestrationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Instance> getWithResponse(String resourceGroupName, String targetName, String solutionName, String instanceName, Context context) {
        Response<InstanceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, targetName, solutionName, instanceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new InstanceImpl((InstanceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Instance get(String resourceGroupName, String targetName, String solutionName, String instanceName) {
        InstanceInner inner = this.serviceClient().get(resourceGroupName, targetName, solutionName, instanceName);
        if (inner != null) {
            return new InstanceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String targetName, String solutionName, String instanceName) {
        this.serviceClient().delete(resourceGroupName, targetName, solutionName, instanceName);
    }

    @Override
    public void delete(String resourceGroupName, String targetName, String solutionName, String instanceName, Context context) {
        this.serviceClient().delete(resourceGroupName, targetName, solutionName, instanceName, context);
    }

    @Override
    public PagedIterable<Instance> listBySolution(String resourceGroupName, String targetName, String solutionName) {
        PagedIterable<InstanceInner> inner = this.serviceClient().listBySolution(resourceGroupName, targetName, solutionName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new InstanceImpl((InstanceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Instance> listBySolution(String resourceGroupName, String targetName, String solutionName, Context context) {
        PagedIterable<InstanceInner> inner = this.serviceClient().listBySolution(resourceGroupName, targetName, solutionName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new InstanceImpl((InstanceInner)((Object)inner1), this.manager()));
    }

    @Override
    public Instance getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String targetName = ResourceManagerUtils.getValueFromIdByName(id, "targets");
        if (targetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'targets'.", id)));
        }
        String solutionName = ResourceManagerUtils.getValueFromIdByName(id, "solutions");
        if (solutionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'solutions'.", id)));
        }
        String instanceName = ResourceManagerUtils.getValueFromIdByName(id, "instances");
        if (instanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'instances'.", id)));
        }
        return (Instance)this.getWithResponse(resourceGroupName, targetName, solutionName, instanceName, Context.NONE).getValue();
    }

    @Override
    public Response<Instance> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String targetName = ResourceManagerUtils.getValueFromIdByName(id, "targets");
        if (targetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'targets'.", id)));
        }
        String solutionName = ResourceManagerUtils.getValueFromIdByName(id, "solutions");
        if (solutionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'solutions'.", id)));
        }
        String instanceName = ResourceManagerUtils.getValueFromIdByName(id, "instances");
        if (instanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'instances'.", id)));
        }
        return this.getWithResponse(resourceGroupName, targetName, solutionName, instanceName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String targetName = ResourceManagerUtils.getValueFromIdByName(id, "targets");
        if (targetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'targets'.", id)));
        }
        String solutionName = ResourceManagerUtils.getValueFromIdByName(id, "solutions");
        if (solutionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'solutions'.", id)));
        }
        String instanceName = ResourceManagerUtils.getValueFromIdByName(id, "instances");
        if (instanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'instances'.", id)));
        }
        this.delete(resourceGroupName, targetName, solutionName, instanceName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String targetName = ResourceManagerUtils.getValueFromIdByName(id, "targets");
        if (targetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'targets'.", id)));
        }
        String solutionName = ResourceManagerUtils.getValueFromIdByName(id, "solutions");
        if (solutionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'solutions'.", id)));
        }
        String instanceName = ResourceManagerUtils.getValueFromIdByName(id, "instances");
        if (instanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'instances'.", id)));
        }
        this.delete(resourceGroupName, targetName, solutionName, instanceName, context);
    }

    private InstancesClient serviceClient() {
        return this.innerClient;
    }

    private WorkloadOrchestrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public InstanceImpl define(String name) {
        return new InstanceImpl(name, this.manager());
    }
}

